/*Variables to use for setup*/

/*Change this if the database has a different name*/
USE [PrickaKonto]

/************************************************************
**
** Check for admin rights
**
************************************************************/
IF NOT EXISTS (SELECT (SELECT HAS_PERMS_BY_NAME(null, null, 'CONTROL SERVER')) WHERE (SELECT HAS_PERMS_BY_NAME(null, null, 'CONTROL SERVER')) = 1)

BEGIN
PRINT 'Script needs to be run as Admin!'
raiserror('Script needs to be run as Admin!', 20, -1) with log
END



/* Read the current version from the database */
IF OBJECT_ID('tempdb.dbo.#upgrade', 'U') IS NOT NULL 
    DROP TABLE #upgrade;

CREATE TABLE #upgrade(CurrentVersion int)
GO
Insert Into #upgrade Select DBVersion FROM GeneralSettings;
GO
DECLARE @CurrentVersion int;
SELECT @CurrentVersion = CurrentVersion FROM #upgrade;
PRINT 'Current version: ' + STR(@CurrentVersion);

/************************************************************
**
** Upgrade to version 11.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) >= 11
BEGIN
 SET NOEXEC ON;
END
GO

PRINT 'Upgrading Database to version: 11'
GO

UPDATE GeneralSettings SET DBVersion = 11 WHERE DBVersion < 11

/****** Object:  Table [dbo].[ReconTransHistory]    Script Date: 2014-10-01 11:05:14 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE TABLE [dbo].[ReconTransHistory](
	[TransHistoryID] [bigint] IDENTITY(1,1) NOT NULL,
	[UpdateID] [int] NOT NULL,
	[AccountID] [int] NOT NULL,
	[ReconHistoryID] [int] NOT NULL,
	[ReconID] [bigint] NOT NULL,
	[ReconDate] [datetime] NOT NULL,
	[ReconRuleID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Date1] [datetime] NOT NULL,
	[Date2] [datetime] NULL,
	[Period] [int] NOT NULL,
	[RefType] [nvarchar](40) NULL,
	[Ref] [nvarchar](1024) NULL,
	[Amount] [decimal](20, 2) NULL,
	[SAmount] [decimal](20, 2) NULL,
	[Text] [nvarchar](1024) NULL,
	[Notes] [nvarchar](1024) NULL,
	[Extra1] [nvarchar](1024) NULL,
	[Extra2] [nvarchar](1024) NULL,
	[Extra3] [nvarchar](1024) NULL,
	[Extra4] [nvarchar](1024) NULL,
	[Extra5] [nvarchar](1024) NULL,
	[Extra6] [nvarchar](1024) NULL,
	[Extra7] [nvarchar](1024) NULL,
	[Extra8] [nvarchar](1024) NULL,
	[Extra9] [nvarchar](1024) NULL,
	[Flag] [tinyint] NULL,
	[DevID] [bigint] NULL,
	[OpUserID] [int] NULL,
 CONSTRAINT [PK_ReconTransHistory] PRIMARY KEY CLUSTERED 
(
	[TransHistoryID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ReconTransHistoryOp]    Script Date: 2014-10-13 15:15:33 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconTransHistoryOp](
	[ReconHistoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[Active] [bit] NOT NULL,
	[ReconGroupID] [int] NOT NULL,
	[ReconDate] [datetime] NULL,
	[Date] [datetime] NOT NULL,
	[Status] [int] NOT NULL,
 CONSTRAINT [PK_ReconTransHistoryOp] PRIMARY KEY CLUSTERED 
(
	[ReconHistoryID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Index [ReconHistoryID]    Script Date: 2014-10-13 15:15:33 ******/
CREATE NONCLUSTERED INDEX [ReconHistoryID] ON [dbo].[ReconTransHistory]
(
	[ReconHistoryID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [UpdateID]    Script Date: 2014-10-13 15:15:33 ******/
CREATE NONCLUSTERED INDEX [UpdateID] ON [dbo].[ReconTransHistory]
(
	[UpdateID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [ReconGroupID]    Script Date: 2014-10-13 15:15:33 ******/
CREATE NONCLUSTERED INDEX [ReconGroupID] ON [dbo].[ReconTransHistoryOp]
(
	[ReconGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [UserID]    Script Date: 2014-10-13 15:15:33 ******/
CREATE NONCLUSTERED INDEX [UserID] ON [dbo].[ReconTransHistoryOp]
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ReconTransHistoryOp] ADD  CONSTRAINT [DF_Table_1_OpDate]  DEFAULT (getdate()) FOR [Date]
GO
ALTER TABLE [dbo].[ReconTransHistory]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistory_ReconTransHistoryOp] FOREIGN KEY([ReconHistoryID])
REFERENCES [dbo].[ReconTransHistoryOp] ([ReconHistoryID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconTransHistory] CHECK CONSTRAINT [FK_ReconTransHistory_ReconTransHistoryOp]
GO
ALTER TABLE [dbo].[ReconTransHistory]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistory_UpdateTrans] FOREIGN KEY([UpdateID])
REFERENCES [dbo].[UpdateTrans] ([UpdateID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconTransHistory] CHECK CONSTRAINT [FK_ReconTransHistory_UpdateTrans]
GO
ALTER TABLE [dbo].[ReconTransHistoryOp]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistoryOp_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconTransHistoryOp] CHECK CONSTRAINT [FK_ReconTransHistoryOp_ReconGroups]
GO
ALTER TABLE [dbo].[ReconTransHistoryOp]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistoryOp_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
GO
ALTER TABLE [dbo].[ReconTransHistoryOp] CHECK CONSTRAINT [FK_ReconTransHistoryOp_Users]
GO


/****** Add New Columns to Accounts and ReconGroups ******/

--ALTER TABLE [dbo].[ReconGroups] ADD [DefaultDiviationAccountID] [int] NULL
ALTER TABLE [dbo].[GeneralSettings] ADD [HistoryDaysLimit] [int] NULL
ALTER TABLE [dbo].[GeneralSettings] ADD [HistoryTransLimit] [int] NULL
ALTER TABLE [dbo].[GeneralSettings] ADD [HistoryRGTransLimit] [int] NULL
ALTER TABLE [dbo].[Transactions] ADD [OpUserID] [int] NULL

GO
UPDATE [dbo].[GeneralSettings] SET [HistoryDaysLimit] = 730, [HistoryTransLimit] = 1000000, [HistoryRGTransLimit] = 150000


GO
--Needed for store procedures to work
GRANT EXECUTE TO PUBLIC
GO



SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
/****** Object:  Table [dbo].[Operation]    Script Date: 2014-11-11 19:26:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Operation](
	[OperationID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[OperationType] [smallint] NOT NULL,
	[Active] [bit] NOT NULL,
	[Date] [datetime] NOT NULL CONSTRAINT [DF_Operation_Date]  DEFAULT (getdate()),
	[Description] [nvarchar](30) NULL,
 CONSTRAINT [PK_Operation] PRIMARY KEY CLUSTERED 
(
	[OperationID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[Operation]  WITH CHECK ADD  CONSTRAINT [FK_Operation_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
GO

ALTER TABLE [dbo].[Operation] CHECK CONSTRAINT [FK_Operation_Users]
GO
/****** Object:  StoredProcedure [dbo].[InsertTransactionsExtra]    Script Date: 2014-11-10 10:19:17 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



ALTER PROCEDURE [dbo].[InsertTransactionsExtra]
 (
 @UpdateID int,
 @AccountID int,
 @Date1 datetime,
 @Date2 datetime,
 @Period int,
 @RefType nvarchar(40),
 @Ref nvarchar(1024),
 @Amount decimal(20,2),
 @SAmount decimal(20,2),
 @Text nvarchar(1024),
 @Extra1 nvarchar(1024),
 @Extra2 nvarchar(1024),
 @Extra3 nvarchar(1024),
 @Extra4 nvarchar(1024),
 @Extra5 nvarchar(1024),
 @Extra6 nvarchar(1024),
 @Extra7 nvarchar(1024),
 @Extra8 nvarchar(1024),
 @Extra9 nvarchar(1024),
 @ReconID bigint,
 @DevID bigint,
 @Notes nvarchar(1024),
 @OpUserID int
 )
AS
 BEGIN 
 
  SET NOCOUNT ON
  
  DECLARE @ParentTransID Table (TransID bigint)

  INSERT INTO dbo.Transactions (UpdateID, AccountID, Date1, Date2, Period, RefType, Ref, Amount, SAmount, Text, Extra1, Extra2, ReconID, DevID, Notes, OpUserID) 
  OUTPUT inserted.TransID INTO @ParentTransID
  VALUES (@UpdateID, @AccountID, @Date1, @Date2, @Period, @RefType, @Ref, @Amount, @SAmount, @Text, @Extra1, @Extra2, @ReconID, @DevID, @Notes, @OpUserID)
  
  INSERT INTO dbo.TransactionsExtra (TransID, Extra3, Extra4, Extra5, Extra6, Extra7, Extra8, Extra9)
  SELECT (SELECT TransID FROM @ParentTransID), @Extra3, @Extra4, @Extra5, @Extra6, @Extra7, @Extra8, @Extra9
 
 END


GO

-- Bundle deviations trans --
DECLARE @UpdateID int

SET @UpdateID = 
(
SELECT TOP 1
  UpdateTrans.UpdateID AS 'UpdateID'
FROM dbo.UpdateTrans
WHERE
  UpdateTrans.UpdateType = 3
)


UPDATE a SET UpdateID = @UpdateID
FROM Transactions a INNER JOIN
(
SELECT 
  UpdateTrans.UpdateID AS 'UpdateID'
FROM dbo.UpdateTrans
WHERE
  UpdateTrans.UpdateType = 3
)

 b ON a.UpdateID = b.UpdateID


 DELETE UpdateTrans FROM  
 UpdateTrans INNER JOIN
 (
 SELECT 
  UpdateTrans.UpdateID AS 'UpdateID'
FROM dbo.Transactions RIGHT OUTER JOIN
  dbo.UpdateTrans ON Transactions.UpdateID = UpdateTrans.UpdateID
GROUP BY UpdateTrans.UpdateID
HAVING COUNT(Transactions.TransID) = 0
) a ON a.UpdateID = UpdateTrans.UpdateID

GO
-- Clear user history - needed for remember treeview state 
UPDATE Users SET History = ''
GO

Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF;
GO

/************************************************************
**
** Upgrade to version 12.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 11
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 12';
GO

/************************************************* UPDATE DB 12 **************************************************/

UPDATE GeneralSettings SET DBVersion = 12 WHERE DBVersion < 12;
GO
/****** 2015-09-08 Add New Columns to GeneralSettings ******/

ALTER TABLE [dbo].[GeneralSettings] ADD [LimitPaintGrid] [int] NULL
ALTER TABLE [dbo].[GeneralSettings] ADD [LimitSearchNextRow] [int] NULL
ALTER TABLE [dbo].[GeneralSettings] ADD [LimitCheckedMemory] [int] NULL
ALTER TABLE [dbo].[GeneralSettings] ADD [LimitSearch] [int] NULL
ALTER TABLE [dbo].[GeneralSettings] ADD [EnableMultiImpUser] [bit] NULL
GO

/************************************************ END UPDATE DB 12 ***********************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF;

/************************************************************
**
** Upgrade to version 13.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 12
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 13';
GO

GO
/************************************************* UPDATE DB 13 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 13 WHERE DBVersion = 12;
/****** 2016-05-20 Add New Column to GeneralSettings ******/
ALTER TABLE [dbo].[GeneralSettings] ADD [Reseller] [smallint] NOT NULL DEFAULT 0
/************************************************ END UPDATE DB 13 ***********************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF

/************************************************************
**
** Upgrade to version 14.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 13
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 14';
GO

/************************************************* UPDATE DB 14 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 14 WHERE DBVersion = 13;

If Object_Id('Tempdb..#TempTransactionsExtra') IS NOT NULL DROP TABLE #TempTransactionsExtra

SELECT 
  TransactionsExtra.TransID AS 'TransID',
  TransactionsExtra.Extra3 AS 'Extra3',
  TransactionsExtra.Extra4 AS 'Extra4',
  TransactionsExtra.Extra5 AS 'Extra5',
  TransactionsExtra.Extra6 AS 'Extra6',
  TransactionsExtra.Extra7 AS 'Extra7',
  TransactionsExtra.Extra8 AS 'Extra8',
  TransactionsExtra.Extra9 AS 'Extra9'
INTO #TempTransactionsExtra
FROM dbo.TransactionsExtra

ALTER TABLE [dbo].[Transactions] ADD [Amount2] [decimal](20,2) NULL
ALTER TABLE [dbo].[Transactions] ADD [SAmount2] [decimal](20,2) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra3] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra4] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra5] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra6] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra7] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra8] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra9] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra10] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra11] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra12] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra13] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra14] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra15] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra16] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra17] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra18] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra19] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra20] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra21] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra22] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra23] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra24] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra25] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra26] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra27] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra28] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra29] [nvarchar](1024) NULL
ALTER TABLE [dbo].[Transactions] ADD [Extra30] [nvarchar](1024) NULL


UPDATE t1
SET t1.Extra3 = t2.Extra3, 
 t1.Extra4 = t2.Extra4, 
 t1.Extra5 = t2.Extra5, 
 t1.Extra6 = t2.Extra6, 
 t1.Extra7 = t2.Extra7, 
 t1.Extra8 = t2.Extra8, 
 t1.Extra9 = t2.Extra9
FROM 
 Transactions t1 INNER JOIN 
 #TempTransactionsExtra t2 ON t1.TransID = t2.TransID;


DROP TABLE TransactionsExtra

ALTER TABLE [dbo].[ReconTransHistory] ADD [Amount2] [decimal](20,2) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [SAmount2] [decimal](20,2) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra10] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra11] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra12] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra13] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra14] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra15] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra16] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra17] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra18] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra19] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra20] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra21] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra22] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra23] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra24] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra25] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra26] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra27] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra28] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra29] [nvarchar](1024) NULL
ALTER TABLE [dbo].[ReconTransHistory] ADD [Extra30] [nvarchar](1024) NULL


--Update ColumnsSettings


If Object_Id('Tempdb..#CS_ID') IS NOT NULL DROP TABLE #CS_ID
If Object_Id('Tempdb..#CS_OLD') IS NOT NULL DROP TABLE #CS_OLD
SET NOCOUNT ON
SELECT 
  ColumnsSettings.ColumnsSettingsID AS 'ColumnsSettingsID',
  ColumnsSettings.ColumnsSettingsName AS 'ColumnsSettingsName',
  ColumnsSettings.ColumnName AS 'ColumnName',
  ColumnsSettings.GridColumnName AS 'GridColumnName',
  ColumnsSettings.ShowColumn AS 'ShowColumn',
  ColumnsSettings.IsEditable AS 'IsEditable',
  ColumnsSettings.IsFiltered AS 'IsFiltered',
  ColumnsSettings.FilterSettings AS 'FilterSettings',
  ColumnsSettings.[Order] AS 'Order'
INTO #CS_OLD
FROM dbo.ColumnsSettings
ORDER BY ColumnsSettings.ColumnsSettingsID ASC,  ColumnsSettings.[Order] ASC


SELECT DISTINCT
  ColumnsSettings.ColumnsSettingsID AS 'ColumnsSettingsID',
  ColumnsSettings.ColumnsSettingsName AS 'ColumnsSettingsName'
INTO #CS_ID
FROM dbo.ColumnsSettings
ORDER BY ColumnsSettings.ColumnsSettingsID ASC


BEGIN

DECLARE @LoopCounter INT , @MaxCSID INT, @ColumnsSettingsID INT
SELECT @LoopCounter = min(ColumnsSettingsID) , @MaxCSID = max(ColumnsSettingsID) 
FROM #CS_ID

DECLARE @ColumnsSettingsName nvarchar(256)
 
WHILE ( @LoopCounter IS NOT NULL
        AND  @LoopCounter <= @MaxCSID)
BEGIN
   SELECT @ColumnsSettingsID = ColumnsSettingsID, @ColumnsSettingsName = ColumnsSettingsName FROM #CS_ID 
   WHERE ColumnsSettingsID = @LoopCounter

INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Amount2', 'Amount2', 0, 0, 0, '', 24)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra10', 'Extra10', 0, 0, 0, '', 25)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra11', 'Extra11', 0, 0, 0, '', 26)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra12', 'Extra12', 0, 0, 0, '', 27)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra13', 'Extra13', 0, 0, 0, '', 28)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra14', 'Extra14', 0, 0, 0, '', 29)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra15', 'Extra15', 0, 0, 0, '', 30)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra16', 'Extra16', 0, 0, 0, '', 31)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra17', 'Extra17', 0, 0, 0, '', 32)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra18', 'Extra18', 0, 0, 0, '', 33)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra19', 'Extra19', 0, 0, 0, '', 34)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra20', 'Extra20', 0, 0, 0, '', 35)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra21', 'Extra21', 0, 0, 0, '', 36)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra22', 'Extra22', 0, 0, 0, '', 37)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra23', 'Extra23', 0, 0, 0, '', 38)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra24', 'Extra24', 0, 0, 0, '', 39)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra25', 'Extra25', 0, 0, 0, '', 40)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra26', 'Extra26', 0, 0, 0, '', 41)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra27', 'Extra27', 0, 0, 0, '', 42)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra28', 'Extra28', 0, 0, 0, '', 43)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra29', 'Extra29', 0, 0, 0, '', 44)  
INSERT #CS_OLD (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
VALUES (@ColumnsSettingsID, @ColumnsSettingsName, 'Extra30', 'Extra30', 0, 0, 0, '', 45)  


   PRINT 'Updating ColumnsSettingsID: ' + CONVERT(varchar(20), @ColumnsSettingsID) + ', ColumnsSettingsName' + @ColumnsSettingsName
   
   SELECT @LoopCounter = min(ColumnsSettingsID) FROM #CS_ID
   WHERE ColumnsSettingsID > @LoopCounter
END

END
SET NOCOUNT OFF

DELETE ColumnsSettings
INSERT INTO ColumnsSettings (ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order])
SELECT ColumnsSettingsID, ColumnsSettingsName, ColumnName, GridColumnName, ShowColumn, IsEditable, IsFiltered, FilterSettings, [Order]
FROM #CS_OLD ORDER BY ColumnsSettingsID, [Order]
GO


DROP PROCEDURE InsertTransactionsExtra
GO

ALTER TABLE [dbo].[ReconRules] ADD [Type] [tinyint] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[ReconRulesStandard] ADD [Type] [tinyint] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[ReconGroups] ADD [ReconcileInBackground] [bit] NOT NULL DEFAULT 0

ALTER TABLE [dbo].[DBLog] ADD [Status] [tinyint] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[DBLog] ADD [TypeID] [int] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[DBLog] ADD [BatchID] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [ReconGroupID] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [PathInfo] [nvarchar](1024) NULL
ALTER TABLE [dbo].[DBLog] ADD [ImportedTrans] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [ExcludedTrans] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [OpenTrans] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [ReconciledTrans] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [PHours] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [PMinutes] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [PSeconds] [int] NULL
ALTER TABLE [dbo].[DBLog] ADD [ImportName] [nvarchar](256) NULL
ALTER TABLE [dbo].[DBLog] ADD [ReconName] [nvarchar](50) NULL

ALTER TABLE [dbo].[ReconTransHistory] ADD [DeletedBundle] [bit] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[ImportInterfaces] ADD [ExcludeTransactions] [bit] NOT NULL DEFAULT 1
GO

CREATE TABLE [dbo].[ReconTransHistoryDeleted](
	[DateDeleted] [datetime] NOT NULL,
	[ReconGroupID] [int] NOT NULL,
	[AccountID] [int] NOT NULL,
	[UpdateID] [int] NOT NULL,
	[ReconHistoryID] [int] NOT NULL,
	[ReconID] [bigint] NOT NULL,
	[ReconDate] [datetime] NOT NULL,
	[ReconRuleID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Date1] [datetime] NOT NULL,
	[Date2] [datetime] NULL,
	[Period] [int] NOT NULL,
	[RefType] [nvarchar](40) NULL,
	[Ref] [nvarchar](1024) NULL,
	[Amount] [decimal](20, 2) NULL,
	[SAmount] [decimal](20, 2) NULL,
	[Text] [nvarchar](1024) NULL,
	[Notes] [nvarchar](1024) NULL,
	[Flag] [tinyint] NULL,
	[DevID] [bigint] NULL,
	[OpUserID] [int] NULL,
	[Amount2] [decimal](20, 2) NULL,
	[SAmount2] [decimal](20, 2) NULL,
	[Extra1] [nvarchar](1024) NULL,
	[Extra2] [nvarchar](1024) NULL,
	[Extra3] [nvarchar](1024) NULL,
	[Extra4] [nvarchar](1024) NULL,
	[Extra5] [nvarchar](1024) NULL,
	[Extra6] [nvarchar](1024) NULL,
	[Extra7] [nvarchar](1024) NULL,
	[Extra8] [nvarchar](1024) NULL,
	[Extra9] [nvarchar](1024) NULL,
	[Extra10] [nvarchar](1024) NULL,
	[Extra11] [nvarchar](1024) NULL,
	[Extra12] [nvarchar](1024) NULL,
	[Extra13] [nvarchar](1024) NULL,
	[Extra14] [nvarchar](1024) NULL,
	[Extra15] [nvarchar](1024) NULL,
	[Extra16] [nvarchar](1024) NULL,
	[Extra17] [nvarchar](1024) NULL,
	[Extra18] [nvarchar](1024) NULL,
	[Extra19] [nvarchar](1024) NULL,
	[Extra20] [nvarchar](1024) NULL,
	[Extra21] [nvarchar](1024) NULL,
	[Extra22] [nvarchar](1024) NULL,
	[Extra23] [nvarchar](1024) NULL,
	[Extra24] [nvarchar](1024) NULL,
	[Extra25] [nvarchar](1024) NULL,
	[Extra26] [nvarchar](1024) NULL,
	[Extra27] [nvarchar](1024) NULL,
	[Extra28] [nvarchar](1024) NULL,
	[Extra29] [nvarchar](1024) NULL,
	[Extra30] [nvarchar](1024) NULL,
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ReconTransHistoryDeleted] ADD  CONSTRAINT [DF_DateDeleted]  DEFAULT (getdate()) FOR [DateDeleted]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD [AppName] [nvarchar](30) NOT NULL DEFAULT 'Pricka Konto'
ALTER TABLE [dbo].[GeneralSettings] ADD [PBEnable] [bit] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[GeneralSettings] ADD [PBMailSendError] [bit] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[GeneralSettings] ADD [PBMailSendCompletedMessage] [bit] NOT NULL DEFAULT 0
ALTER TABLE [dbo].[GeneralSettings] ADD [PBMailNotificationRecipient] [nvarchar](Max) NOT NULL DEFAULT ''
ALTER TABLE [dbo].[GeneralSettings] ADD [DBLogDeleteDaysBackInTime] [int] NOT NULL DEFAULT 90
ALTER TABLE [dbo].[GeneralSettings] ADD [MailSettings] [nvarchar](Max) NULL
GO
UPDATE [dbo].[Reports] SET [FileA] = (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) WHERE ReportName = 'langDeviationReport_'
GO


Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF


/************************************************************
**
** Upgrade to version 15.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 14
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 15';
GO

/************************************************* UPDATE DB 15 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 15 WHERE DBVersion = 14;

ALTER TABLE dbo.Users
ALTER COLUMN EmailAdress nvarchar(256)
GO

CREATE NONCLUSTERED INDEX [AccountID] ON [dbo].[ReconTransHistory]
(
        [AccountID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [ReconID] ON [dbo].[ReconTransHistory]
(
        [ReconID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [UserID] ON [dbo].[ReconTransHistory]
(
        [UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[TransactionGridLayoutsStandard]    Script Date: 2018-06-08 9:37:20 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[TransactionGridLayoutsStandard](
	[SGridLayoutID] [int] IDENTITY(1,1) NOT NULL,
	[SName] [nvarchar](50) NOT NULL,
	[SSplit] [int] NOT NULL,
	[SXML] [nvarchar](max) NOT NULL,
	[SSplitXML] [nvarchar](max) NULL,
 CONSTRAINT [PK_TransactionGridLayoutsStandard_1] PRIMARY KEY CLUSTERED 
(
	[SGridLayoutID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

/****** Object:  Table [dbo].[TransactionGridLayouts]    Script Date: 2018-06-08 9:36:49 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[TransactionGridLayouts](
	[GridLayoutID] [int] IDENTITY(1,1) NOT NULL,
	[SGridLayoutID] [int] NULL,
	[ReconGroupID] [int] NOT NULL,
	[Name] [nvarchar](50) NULL,
	[Split] [int] NULL,
	[XML] [nvarchar](max) NULL,
	[SplitXML] [nvarchar](max) NULL,
 CONSTRAINT [PK_TransactionGridLayouts] PRIMARY KEY CLUSTERED 
(
	[GridLayoutID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

ALTER TABLE [dbo].[TransactionGridLayouts]  WITH CHECK ADD  CONSTRAINT [FK_TransactionGridLayouts_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[TransactionGridLayouts] CHECK CONSTRAINT [FK_TransactionGridLayouts_ReconGroups]
GO

ALTER TABLE [dbo].[TransactionGridLayouts]  WITH CHECK ADD  CONSTRAINT [FK_TransactionGridLayouts_TransactionGridLayoutsStandard] FOREIGN KEY([SGridLayoutID])
REFERENCES [dbo].[TransactionGridLayoutsStandard] ([SGridLayoutID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[TransactionGridLayouts] CHECK CONSTRAINT [FK_TransactionGridLayouts_TransactionGridLayoutsStandard]
GO




/****** Object:  Table [dbo].[ReconGroupGridLayout]    Script Date: 2018-06-08 9:37:34 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[ReconGroupGridLayout](
	[UserID] [int] NOT NULL,
	[ReconGroupID] [int] NOT NULL,
	[GridLayoutID] [int] NULL
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[ReconGroupGridLayout]  WITH CHECK ADD  CONSTRAINT [FK_ReconGroupGridLayout_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
GO

ALTER TABLE [dbo].[ReconGroupGridLayout] CHECK CONSTRAINT [FK_ReconGroupGridLayout_ReconGroups]
GO

ALTER TABLE [dbo].[ReconGroupGridLayout]  WITH CHECK ADD  CONSTRAINT [FK_ReconGroupGridLayout_TransactionGridLayouts] FOREIGN KEY([GridLayoutID])
REFERENCES [dbo].[TransactionGridLayouts] ([GridLayoutID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[ReconGroupGridLayout] CHECK CONSTRAINT [FK_ReconGroupGridLayout_TransactionGridLayouts]
GO

ALTER TABLE [dbo].[ReconGroupGridLayout]  WITH CHECK ADD  CONSTRAINT [FK_ReconGroupGridLayout_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
GO

ALTER TABLE [dbo].[ReconGroupGridLayout] CHECK CONSTRAINT [FK_ReconGroupGridLayout_Users]
GO

ALTER TABLE dbo.GeneralSettings ADD [GlobalLayoutAdminOnly] [BIT] NOT NULL DEFAULT 0
GO

ALTER TABLE [dbo].[Transactions] ADD [ReconDate] [datetime] NULL
ALTER TABLE [dbo].[Transactions] ADD [ReconRuleID] [int] NULL
ALTER TABLE [dbo].[Transactions] ADD [ReconUserID] [int] NULL
GO

If Object_Id('Tempdb..#TempReconTrans') IS NOT NULL DROP TABLE #TempReconTrans

SELECT 
  ReconTrans.ReconID AS 'ReconID',
  ReconTrans.ReconDate AS 'ReconDate',
  ReconTrans.ReconRuleID AS 'ReconRuleID',
  ReconTrans.UserID AS 'UserID'
INTO #TempReconTrans
FROM dbo.ReconTrans

UPDATE t1
SET t1.ReconDate = t2.ReconDate, 
 t1.ReconRuleID = t2.ReconRuleID, 
 t1.ReconUserID = t2.UserID 
FROM 
 Transactions t1 INNER JOIN 
 #TempReconTrans t2 ON t1.ReconID = t2.ReconID;
GO
ALTER TABLE [dbo].[DBLog] ADD [MovedTrans] [int] NULL
GO

/****** Object:  Table [dbo].[UserLayout]    Script Date: 2018-10-25 09:37:01 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[UserLayout](
	[UserID] [int] NOT NULL,
	[Layout] [nvarchar](max) NULL,
 CONSTRAINT [PK_UserLayout] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

ALTER TABLE [dbo].[UserLayout]  WITH CHECK ADD  CONSTRAINT [FK_UserLayout_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[UserLayout] CHECK CONSTRAINT [FK_UserLayout_Users]
GO
/*************************************************END UPDATE DB 15 **************************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF
/************************************************************
**
** Upgrade to version 16.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 15
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 16';
GO
/************************************************* UPDATE DB 16 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 16 WHERE DBVersion = 15;
GO
CREATE TABLE [dbo].[AuditLog](
    [EventId] [int] IDENTITY(1,1) NOT NULL,
    [JsonData] [nvarchar](max) NULL,
    [TimeStamp] [datetime] NULL,
    [UserId] [int] NULL,
    [EntryType] [nvarchar](50) NULL,
 CONSTRAINT [PK_AuditLog] PRIMARY KEY CLUSTERED 
(
    [EventId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_AuditLog_EntryType]    Script Date: 2019-11-01 11:41:50 ******/
CREATE NONCLUSTERED INDEX [IX_AuditLog_EntryType] ON [dbo].[AuditLog]
(
    [EntryType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_AuditLog_TimeStamp]    Script Date: 2019-11-01 11:41:50 ******/
CREATE NONCLUSTERED INDEX [IX_AuditLog_TimeStamp] ON [dbo].[AuditLog]
(
    [TimeStamp] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_AuditLog_UserId]    Script Date: 2019-11-01 11:41:50 ******/
CREATE NONCLUSTERED INDEX [IX_AuditLog_UserId] ON [dbo].[AuditLog]
(
    [UserId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE [dbo].[UpdateTrans] ADD [ExcludeImported] [bit] NULL
GO
ALTER TABLE [dbo].[GeneralSettings] ADD [RemoveAuditLogsOlderThan] [int] NOT NULL DEFAULT 12
GO
/*************************************************END UPDATE DB 16 **************************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF


/************************************************************
**
** Upgrade to version 17.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 16
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 17';
GO
/************************************************* UPDATE DB 17 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 17 WHERE DBVersion = 16;
GO
/****** Object:  Index [OpUserID]    Script Date: 2020-11-12 13:06:10 ******/
CREATE NONCLUSTERED INDEX [OpUserID] ON [dbo].[Transactions]
(
	[OpUserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Index [OpUserID]    Script Date: 2020-11-12 13:05:57 ******/
CREATE NONCLUSTERED INDEX [OpUserID] ON [dbo].[ReconTransHistory]
(
	[OpUserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Index [ColumnsSettingsID]    Script Date: 2020-11-12 13:38:04 ******/
CREATE NONCLUSTERED INDEX [ColumnsSettingsID] ON [dbo].[ColumnsSettings]
(
	[ColumnsSettingsID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Index [ColumnsSettingsID]    Script Date: 2020-11-12 13:39:03 ******/
CREATE NONCLUSTERED INDEX [ColumnsSettingsID] ON [dbo].[ReconGroups]
(
	[ColumnsSettingsID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/*************************************************END UPDATE DB 17 **************************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF


/************************************************************
**
** Upgrade to version 18.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 17
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 18';
GO
/************************************************* UPDATE DB 18 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 18 WHERE DBVersion = 17;


/****** Object:  Table [dbo].[GridLayouts]    Script Date: 2021-05-05 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[GridLayouts](
	[GridLayoutID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[GridType] [int] NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[XML] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_GridLayouts] PRIMARY KEY CLUSTERED 
(
	[GridLayoutID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

ALTER TABLE [dbo].[GridLayouts]  WITH CHECK ADD  CONSTRAINT [FK_GridLayouts_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[GridLayouts] CHECK CONSTRAINT [FK_GridLayouts_Users]
GO
ALTER TABLE [dbo].[UserProfiles] ADD [IsDefaultProfile] [bit] NOT NULL DEFAULT 1
GO
ALTER TABLE [dbo].[UserProfiles] ADD [UserProfilePermission] [nvarchar](max)
GO
/****** Object:  Table [dbo].[RightsGroups]    Script Date: 2021-05-21 09:16:56 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RightsGroups](
	[RightsGroupID] [int] IDENTITY(1,1) NOT NULL,
	[RightsGroupName] [nvarchar](50) NOT NULL,
	[RightsGroupConditions] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_RightsGroups] PRIMARY KEY CLUSTERED 
(
	[RightsGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[UsersRightsGroups]    Script Date: 2021-05-21 09:16:56 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UsersRightsGroups](
	[UserID] [int] NOT NULL,
	[RightsGroupID] [int] NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[UsersRightsGroups]  WITH CHECK ADD  CONSTRAINT [FK_UsersRightsGroups_RightsGroups] FOREIGN KEY([RightsGroupID])
REFERENCES [dbo].[RightsGroups] ([RightsGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UsersRightsGroups] CHECK CONSTRAINT [FK_UsersRightsGroups_RightsGroups]
GO
ALTER TABLE [dbo].[UsersRightsGroups]  WITH CHECK ADD  CONSTRAINT [FK_UsersRightsGroups_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UsersRightsGroups] CHECK CONSTRAINT [FK_UsersRightsGroups_Users]
GO
/****** Object:  Index [UserID]    Script Date: 2021-05-21 09:23:23 ******/
CREATE CLUSTERED INDEX [UserID] ON [dbo].[UsersRightsGroups]
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/*************************************************END UPDATE DB 18 **************************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF


/************************************************************
**
** Upgrade to version 25.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 18
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 25';
GO
/************************************************* UPDATE DB 25 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 25 WHERE DBVersion = 18;

ALTER TABLE [dbo].[ReconRules] ADD [UpdatedByUserID] [int] NOT NULL DEFAULT 1
ALTER TABLE [dbo].[ReconRules]  WITH CHECK ADD CONSTRAINT [FK_ReconRules_Users] FOREIGN KEY([UpdatedByUserID])
REFERENCES [dbo].[Users] ([UserID])
ALTER TABLE [dbo].[ReconRules] ADD [UpdateDate] [datetime]
ALTER TABLE [dbo].[ReconRules] ALTER COLUMN ReconName NVARCHAR (100)

ALTER TABLE [dbo].[ReconRulesStandard] ADD [SUpdatedByUserID] [int] NOT NULL DEFAULT 1
ALTER TABLE [dbo].[ReconRulesStandard]  WITH CHECK ADD CONSTRAINT [FK_ReconRulesStandard_Users] FOREIGN KEY([SUpdatedByUserID])
REFERENCES [dbo].[Users] ([UserID])
ALTER TABLE [dbo].[ReconRulesStandard] ADD [SUpdateDate] [datetime] 
ALTER TABLE [dbo].[ReconRulesStandard] ALTER COLUMN SReconName NVARCHAR (100)
GO
/*************************************************END UPDATE DB 25 **************************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF


/************************************************************
**
** Upgrade to version 26.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 25
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 26';
GO
/************************************************* UPDATE DB 26 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 26 WHERE DBVersion = 25;
ALTER TABLE [dbo].[Transactions] WITH CHECK CHECK CONSTRAINT [FK_Transactions_Accounts]
ALTER TABLE [dbo].[Transactions] WITH CHECK CHECK CONSTRAINT [FK_Transactions_ReconTrans]
ALTER TABLE [dbo].[Transactions] WITH CHECK CHECK CONSTRAINT [FK_Transactions_UpdateTrans]
ALTER TABLE [dbo].[ReconTransHistory] WITH CHECK CHECK CONSTRAINT [FK_ReconTransHistory_ReconTransHistoryOp]
ALTER TABLE [dbo].[ReconTransHistory] WITH CHECK CHECK CONSTRAINT [FK_ReconTransHistory_UpdateTrans]
GO
/*************************************************END UPDATE DB 26 **************************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF

/************************************************************
**
** Upgrade to version 27.
**
*************************************************************/
IF (SELECT CurrentVersion FROM #upgrade) <> 26
BEGIN
 SET NOEXEC ON;
END

PRINT 'Upgrading Database to version: 27';
GO
/************************************************* UPDATE DB 27 **************************************************/
UPDATE [dbo].[GeneralSettings] SET DBVersion = 27 WHERE DBVersion = 26;
ALTER TABLE [dbo].[ImportInterfaces] ADD [AccessTokenURL] [nvarchar](max) NULL
ALTER TABLE [dbo].[ImportInterfaces] ADD [ClientID] [nvarchar](max) NULL
ALTER TABLE [dbo].[ImportInterfaces] ADD [ClientSecret] [nvarchar](max) NULL
GO
/*************************************************END UPDATE DB 27 **************************************************/
Update #upgrade SET CurrentVersion = (Select DBVersion FROM GeneralSettings)
SET NOEXEC OFF

/******************************************************
**
** Add new version above
**
*******************************************************/

DECLARE @CurrentVersion int;
SELECT @CurrentVersion = CurrentVersion FROM #upgrade;
PRINT 'Upgrade complete to version: ' + STR(@CurrentVersion);
DROP TABLE #upgrade

