/*
To change the name of the database do a search and replace on all instances of PrickaKonto.
*/


SET NOEXEC OFF

USE [master]
GO
/****** Object:  Database [PrickaKonto]    Script Date: 2017-09-19 10:00:55 ******/
USE [master]

IF EXISTS (SELECT * FROM sys.databases WHERE NAME = 'PrickaKonto')
BEGIN
	PRINT 'Database already exist';
	SET NOEXEC ON
	RETURN
END
GO

IF  Not EXISTS (SELECT * FROM sys.databases WHERE NAME = 'PrickaKonto')
CREATE DATABASE [PrickaKonto] COLLATE Finnish_Swedish_CI_AS
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [PrickaKonto].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO
ALTER DATABASE [PrickaKonto] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [PrickaKonto] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [PrickaKonto] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [PrickaKonto] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [PrickaKonto] SET ARITHABORT OFF 
GO
ALTER DATABASE [PrickaKonto] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [PrickaKonto] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [PrickaKonto] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [PrickaKonto] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [PrickaKonto] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [PrickaKonto] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [PrickaKonto] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [PrickaKonto] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [PrickaKonto] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [PrickaKonto] SET  DISABLE_BROKER 
GO
ALTER DATABASE [PrickaKonto] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [PrickaKonto] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [PrickaKonto] SET TRUSTWORTHY OFF 
GO
ALTER DATABASE [PrickaKonto] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO
ALTER DATABASE [PrickaKonto] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [PrickaKonto] SET READ_COMMITTED_SNAPSHOT OFF 
GO
ALTER DATABASE [PrickaKonto] SET RECOVERY SIMPLE 
GO
ALTER DATABASE [PrickaKonto] SET  MULTI_USER 
GO
ALTER DATABASE [PrickaKonto] SET PAGE_VERIFY CHECKSUM  
GO
ALTER DATABASE [PrickaKonto] SET DB_CHAINING OFF 
GO
EXEC sys.sp_db_vardecimal_storage_format N'PrickaKonto', N'ON'
GO
USE [PrickaKonto]
GO
--ALTER DATABASE SCOPED CONFIGURATION SET MAXDOP = 0;
--GO
--ALTER DATABASE SCOPED CONFIGURATION FOR SECONDARY SET MAXDOP = PRIMARY;
--GO
--ALTER DATABASE SCOPED CONFIGURATION SET LEGACY_CARDINALITY_ESTIMATION = OFF;
--GO
--ALTER DATABASE SCOPED CONFIGURATION FOR SECONDARY SET LEGACY_CARDINALITY_ESTIMATION = PRIMARY;
--GO
--ALTER DATABASE SCOPED CONFIGURATION SET PARAMETER_SNIFFING = ON;
--GO
--ALTER DATABASE SCOPED CONFIGURATION FOR SECONDARY SET PARAMETER_SNIFFING = PRIMARY;
--GO
--ALTER DATABASE SCOPED CONFIGURATION SET QUERY_OPTIMIZER_HOTFIXES = OFF;
--GO
--ALTER DATABASE SCOPED CONFIGURATION FOR SECONDARY SET QUERY_OPTIMIZER_HOTFIXES = PRIMARY;
--GO
--USE [PrickaKonto]
--GO
PRINT 'Creating users. If users PKSys and PKUser already exists this might give an error, it can be ignored'
CREATE LOGIN PKSys
WITH PASSWORD = 'PKSys',
DEFAULT_DATABASE = PrickaKonto, CHECK_POLICY=OFF;

CREATE LOGIN PKUser
WITH PASSWORD = 'PKUser',
DEFAULT_DATABASE = PrickaKonto, CHECK_POLICY=OFF;

/****** Object:  User [PKUser]    Script Date: 2018-10-31 14:43:25 ******/
CREATE USER [PKUser] FOR LOGIN [PKUser] WITH DEFAULT_SCHEMA=[dbo]
GO
/****** Object:  User [PKSys]    Script Date: 2018-10-31 14:43:25 ******/
CREATE USER [PKSys] FOR LOGIN [PKSys] WITH DEFAULT_SCHEMA=[PKSys]
GO
ALTER ROLE [db_datareader] ADD MEMBER [PKUser]
GO
ALTER ROLE [db_datawriter] ADD MEMBER [PKUser]
GO
ALTER ROLE [db_owner] ADD MEMBER [PKSys]
GO
/****** Object:  Schema [PKSys]    Script Date: 2018-10-31 14:43:26 ******/
CREATE SCHEMA [PKSys]
GO
/****** Object:  Table [dbo].[Accounts]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Accounts](
	[AccountID] [int] IDENTITY(1,1) NOT NULL,
	[AccountType] [tinyint] NOT NULL,
	[Account] [nvarchar](70) NOT NULL,
	[CurrencyID] [int] NOT NULL,
	[Balance] [decimal](20, 2) NOT NULL,
	[ReconGroupID] [int] NOT NULL,
 CONSTRAINT [PK_Accounts] PRIMARY KEY CLUSTERED 
(
	[AccountID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ColumnsSettings]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ColumnsSettings](
	[ColumnsSettingsID] [int] NOT NULL,
	[ColumnsSettingsName] [nvarchar](256) NOT NULL,
	[ColumnName] [nvarchar](10) NOT NULL,
	[GridColumnName] [nvarchar](50) NOT NULL,
	[ShowColumn] [bit] NOT NULL,
	[IsEditable] [bit] NOT NULL,
	[IsFiltered] [bit] NOT NULL,
	[FilterSettings] [nvarchar](max) NULL,
	[Order] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Currency]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Currency](
	[CurrencyID] [int] IDENTITY(1,1) NOT NULL,
	[Code] [nvarchar](3) NOT NULL,
	[Info] [nvarchar](1024) NULL,
 CONSTRAINT [PK_Currency] PRIMARY KEY CLUSTERED 
(
	[CurrencyID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DBLog]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DBLog](
	[LogID] [bigint] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NULL,
	[Message] [nvarchar](4000) NULL,
	[Type] [varchar](30) NOT NULL,
	[LogDate] [datetime] NOT NULL,
	[Status] [tinyint] NOT NULL,
	[TypeID] [int] NOT NULL,
	[BatchID] [int] NULL,
	[ReconGroupID] [int] NULL,
	[PathInfo] [nvarchar](1024) NULL,
	[ImportedTrans] [int] NULL,
	[ExcludedTrans] [int] NULL,
	[OpenTrans] [int] NULL,
	[ReconciledTrans] [int] NULL,
	[PHours] [int] NULL,
	[PMinutes] [int] NULL,
	[PSeconds] [int] NULL,
	[ImportName] [nvarchar](256) NULL,
	[ReconName] [nvarchar](50) NULL,
	[MovedTrans] [int] NULL,
 CONSTRAINT [PK_PrickaLog] PRIMARY KEY CLUSTERED 
(
	[LogID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Entities]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Entities](
	[EntityID] [int] IDENTITY(1,1) NOT NULL,
	[EntityName] [nvarchar](50) NOT NULL,
	[EntityNo] [nvarchar](50) NULL,
	[CompanyName] [nvarchar](60) NULL,
	[Adress1] [nvarchar](60) NULL,
	[Adress2] [nvarchar](60) NULL,
	[ZipCode] [nvarchar](30) NULL,
	[City] [nvarchar](50) NULL,
 CONSTRAINT [PK_Clients] PRIMARY KEY CLUSTERED 
(
	[EntityID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[GeneralSettings]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GeneralSettings](
	[GeneralSettingsID] [int] NOT NULL,
	[CompanyName] [nvarchar](60) NULL,
	[Adress1] [nvarchar](60) NULL,
	[Adress2] [nvarchar](60) NULL,
	[ZipCode] [nvarchar](30) NULL,
	[City] [nvarchar](60) NULL,
	[License] [text] NULL,
	[DBVersion] [smallint] NOT NULL,
	[EnableMainImportsPath] [bit] NOT NULL,
	[EnableAutoImportsPaths] [bit] NOT NULL,
	[MainImportsPath] [nvarchar](1024) NULL,
	[EnableMainArchivePaths] [bit] NOT NULL,
	[MainArchivePath] [nvarchar](1024) NULL,
	[CustomerNumber] [nvarchar](15) NULL,
	[HistoryDaysLimit] [int] NULL,
	[HistoryTransLimit] [int] NULL,
	[HistoryRGTransLimit] [int] NULL,
	[LimitPaintGrid] [int] NULL,
	[LimitSearchNextRow] [int] NULL,
	[LimitCheckedMemory] [int] NULL,
	[LimitSearch] [int] NULL,
	[EnableMultiImpUser] [bit] NULL,
	[Reseller] [smallint] NOT NULL,
	[AppName] [nvarchar](30) NOT NULL,
	[PBEnable] [bit] NOT NULL,
	[PBMailSendError] [bit] NOT NULL,
	[PBMailSendCompletedMessage] [bit] NOT NULL,
	[PBMailNotificationRecipient] [nvarchar](max) NOT NULL,
	[DBLogDeleteDaysBackInTime] [int] NOT NULL,
	[MailSettings] [nvarchar](max) NULL,
	[GlobalLayoutAdminOnly] [bit] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ImportInterfaces]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ImportInterfaces](
	[ImportInterfaceID] [int] IDENTITY(1,1) NOT NULL,
	[ImportName] [nvarchar](256) NOT NULL,
	[Type] [nvarchar](20) NOT NULL,
	[Script] [nvarchar](max) NULL,
	[DLL] [varbinary](max) NULL,
	[Paths] [nvarchar](max) NULL,
	[ActivateParameters] [bit] NOT NULL,
	[ParametersSettings] [nvarchar](max) NULL,
	[ActivateTranslation] [bit] NOT NULL,
	[TranslationSettings] [nvarchar](max) NULL,
	[ActivateBalanceCheck] [bit] NOT NULL,
	[BalanceCheckScript] [nvarchar](max) NULL,
	[BalanceCheckDLL] [varbinary](max) NULL,
	[ImportMultipleEntities] [bit] NOT NULL,
	[ImportMultipleEntitiesPath] [nvarchar](1024) NULL,
	[ImportMultipleEntitiesPathArchive] [nvarchar](1024) NULL,
	[ImportMultipleEntitiesFileFilter] [nvarchar](256) NULL,
	[ModifiedDate] [datetime] NULL,
	[ExcludeTransactions] [bit] NOT NULL,
 CONSTRAINT [PK_ImportInterface] PRIMARY KEY CLUSTERED 
(
	[ImportInterfaceID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Language]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Language](
	[LanguageID] [int] IDENTITY(1,1) NOT NULL,
	[LanguageName] [nvarchar](50) NOT NULL,
	[LanguageCulture] [nvarchar](10) NOT NULL,
	[LanguageSettings] [nvarchar](max) NULL,
	[ColumnsSettingsID] [int] NOT NULL,
 CONSTRAINT [PK_Language] PRIMARY KEY CLUSTERED 
(
	[LanguageID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Operation]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Operation](
	[OperationID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[OperationType] [smallint] NOT NULL,
	[Active] [bit] NOT NULL,
	[Date] [datetime] NOT NULL,
	[Description] [nvarchar](30) NULL,
 CONSTRAINT [PK_Operation] PRIMARY KEY CLUSTERED 
(
	[OperationID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconGroupGridLayout]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconGroupGridLayout](
	[UserID] [int] NOT NULL,
	[ReconGroupID] [int] NOT NULL,
	[GridLayoutID] [int] NULL
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconGroups]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconGroups](
	[ReconGroupID] [int] IDENTITY(1,1) NOT NULL,
	[EntityID] [int] NOT NULL,
	[ReconGroupName] [nvarchar](50) NULL,
	[ColumnsSettingsID] [int] NOT NULL,
	[FilterColor] [nvarchar](max) NULL,
	[DeviationLimit] [decimal](20, 2) NULL,
	[DeviationTransInfoFromNewest] [bit] NULL,
	[LastReconciliation] [tinyint] NULL,
	[AutoReconciliationActive] [smallint] NULL,
	[ExportToAccountID] [int] NULL,
	[DefaultDiviationAccountID] [int] NULL,
	[ReconcileInBackground] [bit] NOT NULL,
 CONSTRAINT [PK_ReconGroup] PRIMARY KEY CLUSTERED 
(
	[ReconGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconRules]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconRules](
	[ReconRuleID] [int] IDENTITY(1,1) NOT NULL,
	[ReconGroupID] [int] NOT NULL,
	[SReconRuleID] [int] NULL,
	[ReconName] [nvarchar](50) NULL,
	[ReconSettings] [nvarchar](max) NULL,
	[ReconOrder] [int] NOT NULL,
	[ReconDescription] [nvarchar](1024) NULL,
	[ReconDoc] [varbinary](max) NULL,
	[IsSuggestionRule] [bit] NOT NULL,
	[Type] [tinyint] NOT NULL,
 CONSTRAINT [PK_ReconRoles] PRIMARY KEY CLUSTERED 
(
	[ReconRuleID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconRulesStandard]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconRulesStandard](
	[SReconRuleID] [int] IDENTITY(1,1) NOT NULL,
	[SReconRuleGroupID] [int] NOT NULL,
	[SReconName] [nvarchar](50) NOT NULL,
	[SReconSettings] [nvarchar](max) NOT NULL,
	[SReconOrder] [int] NOT NULL,
	[SReconDescription] [nvarchar](1024) NULL,
	[SReconDoc] [varbinary](max) NULL,
	[Type] [tinyint] NOT NULL,
 CONSTRAINT [PK_ReconRolesStandard] PRIMARY KEY CLUSTERED 
(
	[SReconRuleID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconRulesStandardGroups]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconRulesStandardGroups](
	[SReconRuleGroupID] [int] IDENTITY(1,1) NOT NULL,
	[SReconRuleGroupName] [nvarchar](50) NOT NULL,
	[SReconRuleGroupDescription] [nvarchar](1024) NULL,
 CONSTRAINT [PK_ReconRulesStandardGroups] PRIMARY KEY CLUSTERED 
(
	[SReconRuleGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconTrans]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconTrans](
	[ReconID] [bigint] IDENTITY(1,1) NOT NULL,
	[ReconDate] [datetime] NOT NULL,
	[ReconRuleID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
 CONSTRAINT [PK_ReconTrans] PRIMARY KEY CLUSTERED 
(
	[ReconID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconTransHistory]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconTransHistory](
	[TransHistoryID] [bigint] IDENTITY(1,1) NOT NULL,
	[UpdateID] [int] NOT NULL,
	[AccountID] [int] NOT NULL,
	[ReconHistoryID] [int] NOT NULL,
	[ReconID] [bigint] NOT NULL,
	[ReconDate] [datetime] NOT NULL,
	[ReconRuleID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Date1] [datetime] NOT NULL,
	[Date2] [datetime] NULL,
	[Period] [int] NOT NULL,
	[RefType] [nvarchar](40) NULL,
	[Ref] [nvarchar](1024) NULL,
	[Amount] [decimal](20, 2) NULL,
	[SAmount] [decimal](20, 2) NULL,
	[Text] [nvarchar](1024) NULL,
	[Notes] [nvarchar](1024) NULL,
	[Extra1] [nvarchar](1024) NULL,
	[Extra2] [nvarchar](1024) NULL,
	[Extra3] [nvarchar](1024) NULL,
	[Extra4] [nvarchar](1024) NULL,
	[Extra5] [nvarchar](1024) NULL,
	[Extra6] [nvarchar](1024) NULL,
	[Extra7] [nvarchar](1024) NULL,
	[Extra8] [nvarchar](1024) NULL,
	[Extra9] [nvarchar](1024) NULL,
	[Flag] [tinyint] NULL,
	[DevID] [bigint] NULL,
	[OpUserID] [int] NULL,
	[Amount2] [decimal](20, 2) NULL,
	[SAmount2] [decimal](20, 2) NULL,
	[Extra10] [nvarchar](1024) NULL,
	[Extra11] [nvarchar](1024) NULL,
	[Extra12] [nvarchar](1024) NULL,
	[Extra13] [nvarchar](1024) NULL,
	[Extra14] [nvarchar](1024) NULL,
	[Extra15] [nvarchar](1024) NULL,
	[Extra16] [nvarchar](1024) NULL,
	[Extra17] [nvarchar](1024) NULL,
	[Extra18] [nvarchar](1024) NULL,
	[Extra19] [nvarchar](1024) NULL,
	[Extra20] [nvarchar](1024) NULL,
	[Extra21] [nvarchar](1024) NULL,
	[Extra22] [nvarchar](1024) NULL,
	[Extra23] [nvarchar](1024) NULL,
	[Extra24] [nvarchar](1024) NULL,
	[Extra25] [nvarchar](1024) NULL,
	[Extra26] [nvarchar](1024) NULL,
	[Extra27] [nvarchar](1024) NULL,
	[Extra28] [nvarchar](1024) NULL,
	[Extra29] [nvarchar](1024) NULL,
	[Extra30] [nvarchar](1024) NULL,
	[DeletedBundle] [bit] NOT NULL,
 CONSTRAINT [PK_ReconTransHistory] PRIMARY KEY CLUSTERED 
(
	[TransHistoryID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconTransHistoryDeleted]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconTransHistoryDeleted](
	[DateDeleted] [datetime] NOT NULL,
	[ReconGroupID] [int] NOT NULL,
	[AccountID] [int] NOT NULL,
	[UpdateID] [int] NOT NULL,
	[ReconHistoryID] [int] NOT NULL,
	[ReconID] [bigint] NOT NULL,
	[ReconDate] [datetime] NOT NULL,
	[ReconRuleID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Date1] [datetime] NOT NULL,
	[Date2] [datetime] NULL,
	[Period] [int] NOT NULL,
	[RefType] [nvarchar](40) NULL,
	[Ref] [nvarchar](1024) NULL,
	[Amount] [decimal](20, 2) NULL,
	[SAmount] [decimal](20, 2) NULL,
	[Text] [nvarchar](1024) NULL,
	[Notes] [nvarchar](1024) NULL,
	[Flag] [tinyint] NULL,
	[DevID] [bigint] NULL,
	[OpUserID] [int] NULL,
	[Amount2] [decimal](20, 2) NULL,
	[SAmount2] [decimal](20, 2) NULL,
	[Extra1] [nvarchar](1024) NULL,
	[Extra2] [nvarchar](1024) NULL,
	[Extra3] [nvarchar](1024) NULL,
	[Extra4] [nvarchar](1024) NULL,
	[Extra5] [nvarchar](1024) NULL,
	[Extra6] [nvarchar](1024) NULL,
	[Extra7] [nvarchar](1024) NULL,
	[Extra8] [nvarchar](1024) NULL,
	[Extra9] [nvarchar](1024) NULL,
	[Extra10] [nvarchar](1024) NULL,
	[Extra11] [nvarchar](1024) NULL,
	[Extra12] [nvarchar](1024) NULL,
	[Extra13] [nvarchar](1024) NULL,
	[Extra14] [nvarchar](1024) NULL,
	[Extra15] [nvarchar](1024) NULL,
	[Extra16] [nvarchar](1024) NULL,
	[Extra17] [nvarchar](1024) NULL,
	[Extra18] [nvarchar](1024) NULL,
	[Extra19] [nvarchar](1024) NULL,
	[Extra20] [nvarchar](1024) NULL,
	[Extra21] [nvarchar](1024) NULL,
	[Extra22] [nvarchar](1024) NULL,
	[Extra23] [nvarchar](1024) NULL,
	[Extra24] [nvarchar](1024) NULL,
	[Extra25] [nvarchar](1024) NULL,
	[Extra26] [nvarchar](1024) NULL,
	[Extra27] [nvarchar](1024) NULL,
	[Extra28] [nvarchar](1024) NULL,
	[Extra29] [nvarchar](1024) NULL,
	[Extra30] [nvarchar](1024) NULL
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReconTransHistoryOp]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReconTransHistoryOp](
	[ReconHistoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[Active] [bit] NOT NULL,
	[ReconGroupID] [int] NOT NULL,
	[ReconDate] [datetime] NULL,
	[Date] [datetime] NOT NULL,
	[Status] [int] NOT NULL,
 CONSTRAINT [PK_ReconTransHistoryOp] PRIMARY KEY CLUSTERED 
(
	[ReconHistoryID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Reports]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Reports](
	[ReportID] [int] IDENTITY(1,1) NOT NULL,
	[ReportName] [nvarchar](50) NULL,
	[ReportType] [smallint] NOT NULL,
	[FileA] [varbinary](max) NULL,
	[FileAFileName] [nvarchar](200) NULL,
	[FileB] [varbinary](max) NULL,
	[FileBFileName] [nvarchar](200) NULL,
	[FileC] [varbinary](max) NULL,
	[FileCFileName] [nvarchar](200) NULL,
	[FileD] [varbinary](max) NULL,
	[FileDFileName] [nvarchar](200) NULL,
	[Rights] [nvarchar](max) NULL,
	[Settings] [nvarchar](max) NULL,
	[IsDefault] [bit] NOT NULL,
	[Enable] [bit] NOT NULL,
	[ModifiedDate] [datetime] NOT NULL,
 CONSTRAINT [PK_Reports] PRIMARY KEY CLUSTERED 
(
	[ReportID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[TransactionGridLayouts]    Script Date: 2018-10-31 14:43:26 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TransactionGridLayouts](
	[GridLayoutID] [int] IDENTITY(1,1) NOT NULL,
	[SGridLayoutID] [int] NULL,
	[ReconGroupID] [int] NOT NULL,
	[Name] [nvarchar](50) NULL,
	[Split] [int] NULL,
	[XML] [nvarchar](max) NULL,
	[SplitXML] [nvarchar](max) NULL,
 CONSTRAINT [PK_TransactionGridLayouts] PRIMARY KEY CLUSTERED 
(
	[GridLayoutID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[TransactionGridLayoutsStandard]    Script Date: 2018-10-31 14:43:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TransactionGridLayoutsStandard](
	[SGridLayoutID] [int] IDENTITY(1,1) NOT NULL,
	[SName] [nvarchar](50) NOT NULL,
	[SSplit] [int] NOT NULL,
	[SXML] [nvarchar](max) NOT NULL,
	[SSplitXML] [nvarchar](max) NULL,
 CONSTRAINT [PK_TransactionGridLayoutsStandard_1] PRIMARY KEY CLUSTERED 
(
	[SGridLayoutID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Transactions]    Script Date: 2018-10-31 14:43:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Transactions](
	[Date1] [datetime] NOT NULL,
	[Date2] [datetime] NULL,
	[Period] [int] NOT NULL,
	[RefType] [nvarchar](40) NULL,
	[Ref] [nvarchar](1024) NULL,
	[Amount] [decimal](20, 2) NULL,
	[SAmount] [decimal](20, 2) NULL,
	[Text] [nvarchar](1024) NULL,
	[Notes] [nvarchar](1024) NULL,
	[Extra1] [nvarchar](1024) NULL,
	[Extra2] [nvarchar](1024) NULL,
	[TransID] [bigint] IDENTITY(1,1) NOT NULL,
	[AccountID] [int] NOT NULL,
	[ReconID] [bigint] NULL,
	[Flag] [tinyint] NULL,
	[UpdateID] [int] NOT NULL,
	[DevID] [bigint] NULL,
	[OpUserID] [int] NULL,
	[Amount2] [decimal](20, 2) NULL,
	[SAmount2] [decimal](20, 2) NULL,
	[Extra3] [nvarchar](1024) NULL,
	[Extra4] [nvarchar](1024) NULL,
	[Extra5] [nvarchar](1024) NULL,
	[Extra6] [nvarchar](1024) NULL,
	[Extra7] [nvarchar](1024) NULL,
	[Extra8] [nvarchar](1024) NULL,
	[Extra9] [nvarchar](1024) NULL,
	[Extra10] [nvarchar](1024) NULL,
	[Extra11] [nvarchar](1024) NULL,
	[Extra12] [nvarchar](1024) NULL,
	[Extra13] [nvarchar](1024) NULL,
	[Extra14] [nvarchar](1024) NULL,
	[Extra15] [nvarchar](1024) NULL,
	[Extra16] [nvarchar](1024) NULL,
	[Extra17] [nvarchar](1024) NULL,
	[Extra18] [nvarchar](1024) NULL,
	[Extra19] [nvarchar](1024) NULL,
	[Extra20] [nvarchar](1024) NULL,
	[Extra21] [nvarchar](1024) NULL,
	[Extra22] [nvarchar](1024) NULL,
	[Extra23] [nvarchar](1024) NULL,
	[Extra24] [nvarchar](1024) NULL,
	[Extra25] [nvarchar](1024) NULL,
	[Extra26] [nvarchar](1024) NULL,
	[Extra27] [nvarchar](1024) NULL,
	[Extra28] [nvarchar](1024) NULL,
	[Extra29] [nvarchar](1024) NULL,
	[Extra30] [nvarchar](1024) NULL,
	[ReconDate] [datetime] NULL,
	[ReconRuleID] [int] NULL,
	[ReconUserID] [int] NULL,
 CONSTRAINT [PK_Transactions] PRIMARY KEY CLUSTERED 
(
	[TransID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[UpdateTrans]    Script Date: 2018-10-31 14:43:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UpdateTrans](
	[UpdateID] [int] IDENTITY(1,1) NOT NULL,
	[PathInfo] [nvarchar](1024) NULL,
	[UpdateDate] [datetime] NOT NULL,
	[FileDate] [datetime] NULL,
	[FileSize] [bigint] NULL,
	[UserID] [int] NOT NULL,
	[ImportInterfaceID] [int] NULL,
	[UpdateType] [smallint] NULL,
	[DV] [int] NULL,
 CONSTRAINT [PK_UpdateTrans] PRIMARY KEY CLUSTERED 
(
	[UpdateID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[UserLayout]    Script Date: 2018-10-31 14:43:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserLayout](
	[UserID] [int] NOT NULL,
	[Layout] [nvarchar](max) NULL,
 CONSTRAINT [PK_UserLayout] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[UserProfiles]    Script Date: 2018-10-31 14:43:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserProfiles](
	[UserProfileID] [int] IDENTITY(1,1) NOT NULL,
	[UserProfileName] [nvarchar](50) NOT NULL,
	[EnableSysAdmin] [bit] NULL,
	[EnableEntityAdmin] [bit] NULL,
	[EnableUpdate] [bit] NULL,
	[EnableAutoRecon] [bit] NULL,
	[EnableArchive] [bit] NULL,
	[EnableReconRoules] [bit] NULL,
	[EnableRecon] [bit] NULL,
	[EnableReconDiff] [bit] NULL,
	[EnableManReg] [bit] NULL,
	[EnableReport] [bit] NULL,
	[EnableUndoUpdate] [bit] NULL,
 CONSTRAINT [PK_UserProfile] PRIMARY KEY CLUSTERED 
(
	[UserProfileID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Users]    Script Date: 2018-10-31 14:43:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Users](
	[UserID] [int] IDENTITY(1,1) NOT NULL,
	[UserProfileID] [int] NOT NULL,
	[UserName] [nvarchar](50) NOT NULL,
	[Password] [nvarchar](50) NULL,
	[Title] [nvarchar](8) NULL,
	[FirstName] [nvarchar](50) NULL,
	[MiddleName] [nvarchar](50) NULL,
	[LastName] [nvarchar](50) NULL,
	[Suffix] [nvarchar](10) NULL,
	[EmailAdress] [nvarchar](256) NULL,
	[Image] [image] NULL,
	[ImageAdress] [text] NULL,
	[Activated] [bit] NOT NULL,
	[WinAut] [bit] NOT NULL,
	[History] [nvarchar](max) NULL,
	[Rights] [nvarchar](max) NULL,
	[LastLogin] [datetime] NULL,
	[IsLogged] [bit] NULL,
	[LanguageID] [int] NOT NULL,
 CONSTRAINT [PK_Users] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Flag', N'', 1, 0, 0, N'', 1)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Account', N'Account', 1, 0, 0, N'', 2)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Period', N'Period', 0, 0, 0, N'', 3)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Date1', N'Date1', 1, 0, 0, N'', 4)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Date2', N'Date2', 0, 0, 0, N'', 5)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'RefType', N'RefType', 1, 0, 0, N'', 6)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Ref', N'Referens', 1, 0, 0, N'', 7)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Amount', N'Amount', 1, 0, 0, N'', 8)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'RSelect', N'', 1, 1, 0, N'', 9)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Text', N'Text', 1, 0, 0, N'', 10)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Notes', N'Notes', 1, 1, 0, N'', 11)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra1', N'Extra1', 0, 0, 0, N'', 12)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra2', N'Extra2', 0, 0, 0, N'', 13)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra3', N'Extra3', 0, 0, 0, N'', 14)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra4', N'Extra4', 0, 0, 0, N'', 15)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra5', N'Extra5', 0, 0, 0, N'', 16)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra6', N'Extra6', 0, 0, 0, N'', 17)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra7', N'Extra7', 0, 0, 0, N'', 18)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra8', N'Extra8', 0, 0, 0, N'', 19)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra9', N'Extra9', 0, 0, 0, N'', 20)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'ReconID', N'Recon ID', 1, 0, 0, N'', 21)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'ReconDate', N'ReconDate', 1, 0, 0, N'', 22)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'UserName', N'User', 1, 0, 0, N'', 23)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Flag', N'', 1, 0, 0, N'', 1)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Account', N'Konto', 1, 0, 0, N'', 2)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Period', N'Period', 0, 0, 0, N'', 3)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Date1', N'Datum1', 1, 0, 0, N'', 4)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Date2', N'Datum2', 0, 0, 0, N'', 5)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'RefType', N'RefTyp', 1, 0, 0, N'', 6)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Ref', N'Referens', 1, 0, 0, N'', 7)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Amount', N'Belopp', 1, 0, 0, N'', 8)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'RSelect', N'', 1, 1, 0, N'', 9)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Text', N'Text', 1, 0, 0, N'', 10)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Notes', N'Anteckningar', 1, 1, 0, N'', 11)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra1', N'Extra1', 0, 0, 0, N'', 12)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra2', N'Extra2', 0, 0, 0, N'', 13)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra3', N'Extra3', 0, 0, 0, N'', 14)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra4', N'Extra4', 0, 0, 0, N'', 15)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra5', N'Extra5', 0, 0, 0, N'', 16)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra6', N'Extra6', 0, 0, 0, N'', 17)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra7', N'Extra7', 0, 0, 0, N'', 18)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra8', N'Extra8', 0, 0, 0, N'', 19)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra9', N'Extra9', 0, 0, 0, N'', 20)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'ReconID', N'AvstämningsID', 1, 0, 0, N'', 21)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'ReconDate', N'AvstämningsDatum', 1, 0, 0, N'', 22)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'UserName', N'Användare', 1, 0, 0, N'', 23)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Flag', N'', 1, 0, 0, N'', 1)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Account', N'Account', 1, 0, 0, N'', 2)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Period', N'Period', 0, 0, 0, N'', 3)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Date1', N'Date1', 1, 0, 0, N'', 4)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Date2', N'Date2', 0, 0, 0, N'', 5)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'RefType', N'RefType', 1, 0, 0, N'', 6)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Ref', N'Referens', 1, 0, 0, N'', 7)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Amount', N'Amount', 1, 0, 0, N'', 8)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'RSelect', N'', 1, 1, 0, N'', 9)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Text', N'Text', 1, 0, 0, N'', 10)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Notes', N'Notes', 1, 1, 0, N'', 11)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra1', N'Extra1', 0, 0, 0, N'', 12)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra2', N'Extra2', 0, 0, 0, N'', 13)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra3', N'Extra3', 0, 0, 0, N'', 14)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra4', N'Extra4', 0, 0, 0, N'', 15)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra5', N'Extra5', 0, 0, 0, N'', 16)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra6', N'Extra6', 0, 0, 0, N'', 17)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra7', N'Extra7', 0, 0, 0, N'', 18)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra8', N'Extra8', 0, 0, 0, N'', 19)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra9', N'Extra9', 0, 0, 0, N'', 20)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'ReconID', N'Recon ID', 1, 0, 0, N'', 21)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'ReconDate', N'ReconDate', 1, 0, 0, N'', 22)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'UserName', N'User', 1, 0, 0, N'', 23)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Flag', N'', 1, 0, 0, N'', 1)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Account', N'Konto', 1, 0, 0, N'', 2)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Period', N'Periode', 0, 0, 0, N'', 3)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Date1', N'Dato1', 1, 0, 0, N'', 4)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Date2', N'Dato2', 0, 0, 0, N'', 5)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'RefType', N'ReferanseType', 1, 0, 0, N'', 6)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Ref', N'Referanse', 1, 0, 0, N'', 7)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Amount', N'Beløp', 1, 0, 0, N'', 8)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'RSelect', N'', 1, 1, 0, N'', 9)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Text', N'Tekst', 1, 0, 0, N'', 10)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Notes', N'Notater', 1, 1, 0, N'', 11)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra1', N'Ekstra1', 0, 0, 0, N'', 12)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra2', N'Ekstra2', 0, 0, 0, N'', 13)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra3', N'Ekstra3', 0, 0, 0, N'', 14)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra4', N'Ekstra4', 0, 0, 0, N'', 15)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra5', N'Ekstra5', 0, 0, 0, N'', 16)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra6', N'Ekstra6', 0, 0, 0, N'', 17)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra7', N'Ekstra7', 0, 0, 0, N'', 18)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra8', N'Ekstra8', 0, 0, 0, N'', 19)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra9', N'Ekstra9', 0, 0, 0, N'', 20)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'ReconID', N'AvstemmingsID', 1, 0, 0, N'', 21)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'ReconDate', N'AvstemmingsDato', 1, 0, 0, N'', 22)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'UserName', N'Brukere', 1, 0, 0, N'', 23)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Flag', N'', 1, 0, 0, N'', 1)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Account', N'Account', 1, 0, 0, N'', 2)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Period', N'Period', 0, 0, 0, N'', 3)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Date1', N'Date1', 1, 0, 0, N'', 4)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Date2', N'Date2', 0, 0, 0, N'', 5)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'RefType', N'RefType', 1, 0, 0, N'', 6)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Ref', N'Referens', 1, 0, 0, N'', 7)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Amount', N'Amount', 1, 0, 0, N'', 8)
GO
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'RSelect', N'', 1, 1, 0, N'', 9)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Text', N'Text', 1, 0, 0, N'', 10)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Notes', N'Notes', 1, 1, 0, N'', 11)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra1', N'Extra1', 0, 0, 0, N'', 12)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra2', N'Extra2', 0, 0, 0, N'', 13)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra3', N'Extra3', 0, 0, 0, N'', 14)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra4', N'Extra4', 0, 0, 0, N'', 15)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra5', N'Extra5', 0, 0, 0, N'', 16)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra6', N'Extra6', 0, 0, 0, N'', 17)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra7', N'Extra7', 0, 0, 0, N'', 18)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra8', N'Extra8', 0, 0, 0, N'', 19)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra9', N'Extra9', 0, 0, 0, N'', 20)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'ReconID', N'Recon ID', 1, 0, 0, N'', 21)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'ReconDate', N'ReconDate', 1, 0, 0, N'', 22)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'UserName', N'User', 1, 0, 0, N'', 23)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Amount2', N'Amount2', 0, 0, 0, N'', 24)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra10', N'Extra10', 0, 0, 0, N'', 25)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra11', N'Extra11', 0, 0, 0, N'', 26)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra12', N'Extra12', 0, 0, 0, N'', 27)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra13', N'Extra13', 0, 0, 0, N'', 28)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra14', N'Extra14', 0, 0, 0, N'', 29)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra15', N'Extra15', 0, 0, 0, N'', 30)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra16', N'Extra16', 0, 0, 0, N'', 31)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra17', N'Extra17', 0, 0, 0, N'', 32)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra18', N'Extra18', 0, 0, 0, N'', 33)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra19', N'Extra19', 0, 0, 0, N'', 34)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra20', N'Extra20', 0, 0, 0, N'', 35)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra21', N'Extra21', 0, 0, 0, N'', 36)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra22', N'Extra22', 0, 0, 0, N'', 37)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra23', N'Extra23', 0, 0, 0, N'', 38)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra24', N'Extra24', 0, 0, 0, N'', 39)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra25', N'Extra25', 0, 0, 0, N'', 40)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra26', N'Extra26', 0, 0, 0, N'', 41)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra27', N'Extra27', 0, 0, 0, N'', 42)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra28', N'Extra28', 0, 0, 0, N'', 43)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra29', N'Extra29', 0, 0, 0, N'', 44)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (1, N'Default_en', N'Extra30', N'Extra30', 0, 0, 0, N'', 45)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Amount2', N'Amount2', 0, 0, 0, N'', 24)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra10', N'Extra10', 0, 0, 0, N'', 25)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra11', N'Extra11', 0, 0, 0, N'', 26)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra12', N'Extra12', 0, 0, 0, N'', 27)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra13', N'Extra13', 0, 0, 0, N'', 28)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra14', N'Extra14', 0, 0, 0, N'', 29)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra15', N'Extra15', 0, 0, 0, N'', 30)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra16', N'Extra16', 0, 0, 0, N'', 31)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra17', N'Extra17', 0, 0, 0, N'', 32)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra18', N'Extra18', 0, 0, 0, N'', 33)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra19', N'Extra19', 0, 0, 0, N'', 34)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra20', N'Extra20', 0, 0, 0, N'', 35)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra21', N'Extra21', 0, 0, 0, N'', 36)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra22', N'Extra22', 0, 0, 0, N'', 37)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra23', N'Extra23', 0, 0, 0, N'', 38)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra24', N'Extra24', 0, 0, 0, N'', 39)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra25', N'Extra25', 0, 0, 0, N'', 40)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra26', N'Extra26', 0, 0, 0, N'', 41)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra27', N'Extra27', 0, 0, 0, N'', 42)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra28', N'Extra28', 0, 0, 0, N'', 43)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra29', N'Extra29', 0, 0, 0, N'', 44)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (2, N'Default_sv', N'Extra30', N'Extra30', 0, 0, 0, N'', 45)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Amount2', N'Amount2', 0, 0, 0, N'', 24)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra10', N'Extra10', 0, 0, 0, N'', 25)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra11', N'Extra11', 0, 0, 0, N'', 26)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra12', N'Extra12', 0, 0, 0, N'', 27)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra13', N'Extra13', 0, 0, 0, N'', 28)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra14', N'Extra14', 0, 0, 0, N'', 29)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra15', N'Extra15', 0, 0, 0, N'', 30)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra16', N'Extra16', 0, 0, 0, N'', 31)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra17', N'Extra17', 0, 0, 0, N'', 32)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra18', N'Extra18', 0, 0, 0, N'', 33)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra19', N'Extra19', 0, 0, 0, N'', 34)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra20', N'Extra20', 0, 0, 0, N'', 35)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra21', N'Extra21', 0, 0, 0, N'', 36)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra22', N'Extra22', 0, 0, 0, N'', 37)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra23', N'Extra23', 0, 0, 0, N'', 38)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra24', N'Extra24', 0, 0, 0, N'', 39)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra25', N'Extra25', 0, 0, 0, N'', 40)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra26', N'Extra26', 0, 0, 0, N'', 41)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra27', N'Extra27', 0, 0, 0, N'', 42)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra28', N'Extra28', 0, 0, 0, N'', 43)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra29', N'Extra29', 0, 0, 0, N'', 44)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (3, N'Default_dk', N'Extra30', N'Extra30', 0, 0, 0, N'', 45)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Amount2', N'Amount2', 0, 0, 0, N'', 24)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra10', N'Extra10', 0, 0, 0, N'', 25)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra11', N'Extra11', 0, 0, 0, N'', 26)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra12', N'Extra12', 0, 0, 0, N'', 27)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra13', N'Extra13', 0, 0, 0, N'', 28)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra14', N'Extra14', 0, 0, 0, N'', 29)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra15', N'Extra15', 0, 0, 0, N'', 30)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra16', N'Extra16', 0, 0, 0, N'', 31)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra17', N'Extra17', 0, 0, 0, N'', 32)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra18', N'Extra18', 0, 0, 0, N'', 33)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra19', N'Extra19', 0, 0, 0, N'', 34)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra20', N'Extra20', 0, 0, 0, N'', 35)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra21', N'Extra21', 0, 0, 0, N'', 36)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra22', N'Extra22', 0, 0, 0, N'', 37)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra23', N'Extra23', 0, 0, 0, N'', 38)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra24', N'Extra24', 0, 0, 0, N'', 39)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra25', N'Extra25', 0, 0, 0, N'', 40)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra26', N'Extra26', 0, 0, 0, N'', 41)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra27', N'Extra27', 0, 0, 0, N'', 42)
GO
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra28', N'Extra28', 0, 0, 0, N'', 43)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra29', N'Extra29', 0, 0, 0, N'', 44)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (4, N'Default_no', N'Extra30', N'Extra30', 0, 0, 0, N'', 45)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Amount2', N'Amount2', 0, 0, 0, N'', 24)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra10', N'Extra10', 0, 0, 0, N'', 25)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra11', N'Extra11', 0, 0, 0, N'', 26)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra12', N'Extra12', 0, 0, 0, N'', 27)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra13', N'Extra13', 0, 0, 0, N'', 28)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra14', N'Extra14', 0, 0, 0, N'', 29)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra15', N'Extra15', 0, 0, 0, N'', 30)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra16', N'Extra16', 0, 0, 0, N'', 31)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra17', N'Extra17', 0, 0, 0, N'', 32)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra18', N'Extra18', 0, 0, 0, N'', 33)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra19', N'Extra19', 0, 0, 0, N'', 34)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra20', N'Extra20', 0, 0, 0, N'', 35)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra21', N'Extra21', 0, 0, 0, N'', 36)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra22', N'Extra22', 0, 0, 0, N'', 37)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra23', N'Extra23', 0, 0, 0, N'', 38)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra24', N'Extra24', 0, 0, 0, N'', 39)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra25', N'Extra25', 0, 0, 0, N'', 40)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra26', N'Extra26', 0, 0, 0, N'', 41)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra27', N'Extra27', 0, 0, 0, N'', 42)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra28', N'Extra28', 0, 0, 0, N'', 43)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra29', N'Extra29', 0, 0, 0, N'', 44)
INSERT [dbo].[ColumnsSettings] ([ColumnsSettingsID], [ColumnsSettingsName], [ColumnName], [GridColumnName], [ShowColumn], [IsEditable], [IsFiltered], [FilterSettings], [Order]) VALUES (5, N'Default_fi', N'Extra30', N'Extra30', 0, 0, 0, N'', 45)
SET IDENTITY_INSERT [dbo].[Currency] ON 

INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (1, N'AED', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (2, N'AFN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (3, N'ALL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (4, N'AMD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (5, N'ANG', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (6, N'AOA', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (7, N'ARS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (8, N'AUD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (9, N'AWG', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (10, N'AZN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (11, N'BAM', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (12, N'BBD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (13, N'BDT', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (14, N'BGN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (15, N'BHD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (16, N'BIF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (17, N'BMD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (18, N'BND', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (19, N'BOB', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (20, N'BOV', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (21, N'BRL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (22, N'BSD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (23, N'BTN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (24, N'BWP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (25, N'BYR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (26, N'BZD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (27, N'CAD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (28, N'CDF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (29, N'CHE', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (30, N'CHF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (31, N'CHW', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (32, N'CLF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (33, N'CLP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (34, N'CNY', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (35, N'COP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (36, N'COU', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (37, N'CRC', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (38, N'CUC', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (39, N'CUP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (40, N'CVE', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (41, N'CZK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (42, N'DJF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (43, N'DKK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (44, N'DOP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (45, N'DZD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (46, N'EGP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (47, N'ERN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (48, N'ETB', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (49, N'EUR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (50, N'FJD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (51, N'FKP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (52, N'GBP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (53, N'GEL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (54, N'GHS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (55, N'GIP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (56, N'GMD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (57, N'GNF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (58, N'GTQ', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (59, N'GYD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (60, N'HKD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (61, N'HNL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (62, N'HRK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (63, N'HTG', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (64, N'HUF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (65, N'IDR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (66, N'ILS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (67, N'INR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (68, N'IQD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (69, N'IRR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (70, N'ISK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (71, N'JMD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (72, N'JOD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (73, N'JPY', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (74, N'KES', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (75, N'KGS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (76, N'KHR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (77, N'KMF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (78, N'KPW', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (79, N'KRW', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (80, N'KWD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (81, N'KYD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (82, N'KZT', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (83, N'LAK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (84, N'LBP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (85, N'LKR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (86, N'LRD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (87, N'LSL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (88, N'LTL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (89, N'LVL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (90, N'LYD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (91, N'MAD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (92, N'MDL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (93, N'MGA', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (94, N'MKD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (95, N'MMK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (96, N'MNT', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (97, N'MOP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (98, N'MRO', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (99, N'MUR', NULL)
GO
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (100, N'MWK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (101, N'MVR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (102, N'MXN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (103, N'MXV', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (104, N'MYR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (105, N'MZN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (106, N'NAD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (107, N'NGN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (108, N'NIO', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (109, N'NOK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (110, N'NPR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (111, N'NZD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (112, N'OMR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (113, N'PAB', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (114, N'PEN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (115, N'PGK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (116, N'PHP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (117, N'PKR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (118, N'PLN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (119, N'PYG', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (120, N'QAR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (121, N'RON', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (122, N'RSD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (123, N'RUB', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (124, N'RWF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (125, N'SAR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (126, N'SBD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (127, N'SCR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (128, N'SDG', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (129, N'SEK', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (130, N'SGD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (131, N'SHP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (132, N'SLL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (133, N'SOS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (134, N'SRD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (135, N'SSP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (136, N'STD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (137, N'SYP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (138, N'SZL', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (139, N'THB', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (140, N'TJS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (141, N'TMT', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (142, N'TND', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (143, N'TOP', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (144, N'TRY', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (145, N'TTD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (146, N'TWD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (147, N'TZS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (148, N'UAH', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (149, N'UGX', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (150, N'USD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (151, N'USN', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (152, N'USS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (153, N'UYI', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (154, N'UYU', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (155, N'UZS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (156, N'VEF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (157, N'VND', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (158, N'WST', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (159, N'VUV', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (160, N'XAF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (161, N'XAG', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (162, N'XAU', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (163, N'XBA', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (164, N'XBB', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (165, N'XBC', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (166, N'XBD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (167, N'XCD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (168, N'XDR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (169, N'XFU', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (170, N'XOF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (171, N'XPD', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (172, N'XPF', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (173, N'XPT', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (174, N'XTS', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (175, N'XXX', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (176, N'YER', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (177, N'ZAR', NULL)
INSERT [dbo].[Currency] ([CurrencyID], [Code], [Info]) VALUES (178, N'ZMW', NULL)
SET IDENTITY_INSERT [dbo].[Currency] OFF
INSERT [dbo].[GeneralSettings] ([GeneralSettingsID], [CompanyName], [Adress1], [Adress2], [ZipCode], [City], [License], [DBVersion], [EnableMainImportsPath], [EnableAutoImportsPaths], [MainImportsPath], [EnableMainArchivePaths], [MainArchivePath], [CustomerNumber], [HistoryDaysLimit], [HistoryTransLimit], [HistoryRGTransLimit], [LimitPaintGrid], [LimitSearchNextRow], [LimitCheckedMemory], [LimitSearch], [EnableMultiImpUser], [Reseller], [AppName], [PBEnable], [PBMailSendError], [PBMailSendCompletedMessage], [PBMailNotificationRecipient], [DBLogDeleteDaysBackInTime], [MailSettings], [GlobalLayoutAdminOnly]) VALUES (1, N'Demo', N'', N'', N'', N'', N'', 15, 0, 0, NULL, 0, NULL, N'Demo', 730, 1000000, 150000, NULL, NULL, NULL, NULL, NULL, 0, N'Pricka Konto', 0, 0, 0, N'', 90, NULL, 0)
SET IDENTITY_INSERT [dbo].[Language] ON 

INSERT [dbo].[Language] ([LanguageID], [LanguageName], [LanguageCulture], [LanguageSettings], [ColumnsSettingsID]) VALUES (1, N'English', N'en', N'', 1)
INSERT [dbo].[Language] ([LanguageID], [LanguageName], [LanguageCulture], [LanguageSettings], [ColumnsSettingsID]) VALUES (2, N'Svenska', N'sv', N'', 2)
INSERT [dbo].[Language] ([LanguageID], [LanguageName], [LanguageCulture], [LanguageSettings], [ColumnsSettingsID]) VALUES (3, N'Dansk', N'da', N'', 3)
INSERT [dbo].[Language] ([LanguageID], [LanguageName], [LanguageCulture], [LanguageSettings], [ColumnsSettingsID]) VALUES (4, N'Norsk', N'no', N'', 4)
INSERT [dbo].[Language] ([LanguageID], [LanguageName], [LanguageCulture], [LanguageSettings], [ColumnsSettingsID]) VALUES (5, N'Suomi', N'fi', N'', 5)
SET IDENTITY_INSERT [dbo].[Language] OFF
SET IDENTITY_INSERT [dbo].[Reports] ON 

INSERT [dbo].[Reports] ([ReportID], [ReportName], [ReportType], [FileA], [FileAFileName], [FileB], [FileBFileName], [FileC], [FileCFileName], [FileD], [FileDFileName], [Rights], [Settings], [IsDefault], [Enable], [ModifiedDate]) VALUES (1, N'langOpenItems_', 1, 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, N'OpenItemsReport.rdl', 0x3C3F786D6C2076657273696F6E3D22312E302220656E636F64696E673D225554462D38223F3E0D0A3C5265706F727420786D6C6E733D22687474703A2F2F736368656D61732E6D6963726F736F66742E636F6D2F73716C7365727665722F7265706F7274696E672F323030352F30312F7265706F7274646566696E6974696F6E2220786D6C6E733A72643D22687474703A2F2F736368656D61732E6D6963726F736F66742E636F6D2F53514C5365727665722F7265706F7274696E672F7265706F727464657369676E6572223E0D0A20203C4465736372697074696F6E3E0D0A20203C2F4465736372697074696F6E3E0D0A20203C417574686F723E0D0A20203C2F417574686F723E0D0A20203C506167654865696768743E382E35696E3C2F506167654865696768743E0D0A20203C5061676557696474683E3131696E3C2F5061676557696474683E0D0A20203C57696474683E372E35696E3C2F57696474683E0D0A20203C546F704D617267696E3E2E3235696E3C2F546F704D617267696E3E0D0A20203C4C6566744D617267696E3E2E3235696E3C2F4C6566744D617267696E3E0D0A20203C52696768744D617267696E3E2E3235696E3C2F52696768744D617267696E3E0D0A20203C426F74746F6D4D617267696E3E2E3235696E3C2F426F74746F6D4D617267696E3E0D0A20203C44617461536574733E0D0A202020203C44617461536574204E616D653D2244617461223E0D0A2020202020203C51756572793E0D0A20202020202020203C44617461536F757263654E616D653E4453313C2F44617461536F757263654E616D653E0D0A20202020202020203C436F6D6D616E64546578743E53454C454354205472616E73616374696F6E732E44617465312C200A5472616E73616374696F6E732E5265662C0A5472616E73616374696F6E732E416D6F756E742C5472616E73616374696F6E732E53416D6F756E742C0A5472616E73616374696F6E732E546578742C0A5472616E73616374696F6E732E4E6F7465732C0A5472616E73616374696F6E732E4578747261312C0A4163636F756E74732E4163636F756E742C200A4163636F756E74732E5B4163636F756E74547970655D2C200A5265636F6E47726F7570732E5265636F6E47726F75704E616D652C0A5265636F6E47726F7570732E5265636F6E47726F75704944202C200A456E7469746965732E456E746974794E616D65200A46524F4D205472616E73616374696F6E732C204163636F756E74732C205265636F6E47726F7570732C20456E746974696573200A5748455245205472616E73616374696F6E732E5265636F6E4944204953204E554C4C200A414E44204163636F756E74732E4163636F756E7449443D5472616E73616374696F6E732E4163636F756E744944200A414E44205265636F6E47726F7570732E5265636F6E47726F757049443D4163636F756E74732E5265636F6E47726F757049440A414E44205265636F6E47726F7570732E456E7469747949443D456E7469746965732E456E7469747949440A414E44205265636F6E47726F7570732E5265636F6E47726F7570494420494E202840706172616D4D756C74695265636F6E47726F757049445F29200A4F5244455220425920456E7469746965732E456E746974794E616D652C5265636F6E47726F7570732E5265636F6E47726F75704E616D653C2F436F6D6D616E64546578743E0D0A20202020202020203C5175657279506172616D65746572733E0D0A202020202020202020203C5175657279506172616D65746572204E616D653D22706172616D4D756C74695265636F6E47726F757049445F223E0D0A2020202020202020202020203C56616C75653E3D506172616D657465727321706172616D4D756C74695265636F6E47726F757049445F3C2F56616C75653E0D0A202020202020202020203C2F5175657279506172616D657465723E0D0A20202020202020203C2F5175657279506172616D65746572733E0D0A2020202020203C2F51756572793E0D0A2020202020203C4669656C64733E0D0A20202020202020203C4669656C64204E616D653D224461746531223E0D0A202020202020202020203C446174614669656C643E44617465313C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E4461746554696D653C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D22526566223E0D0A202020202020202020203C446174614669656C643E5265663C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E537472696E673C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D22416D6F756E74223E0D0A202020202020202020203C446174614669656C643E416D6F756E743C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E446563696D616C3C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D2254657874223E0D0A202020202020202020203C446174614669656C643E546578743C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E537472696E673C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D22457874726131223E0D0A202020202020202020203C446174614669656C643E4578747261313C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E537472696E673C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D224163636F756E74223E0D0A202020202020202020203C446174614669656C643E4163636F756E743C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E537472696E673C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D224163636F756E7454797065223E0D0A202020202020202020203C446174614669656C643E4163636F756E74547970653C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E427974653C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D225265636F6E47726F75704E616D65223E0D0A202020202020202020203C446174614669656C643E5265636F6E47726F75704E616D653C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E537472696E673C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D225265636F6E47726F75704944223E0D0A202020202020202020203C446174614669656C643E5265636F6E47726F757049443C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E496E7433323C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D22456E746974794E616D65223E0D0A202020202020202020203C446174614669656C643E456E746974794E616D653C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E537472696E673C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D224E6F746573223E0D0A202020202020202020203C446174614669656C643E4E6F7465733C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E537472696E673C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A20202020202020203C4669656C64204E616D653D2253416D6F756E74223E0D0A202020202020202020203C446174614669656C643E53416D6F756E743C2F446174614669656C643E0D0A202020202020202020203C72643A547970654E616D653E53797374656D2E446563696D616C3C2F72643A547970654E616D653E0D0A20202020202020203C2F4669656C643E0D0A2020202020203C2F4669656C64733E0D0A202020203C2F446174615365743E0D0A20203C2F44617461536574733E0D0A20203C506167654865616465723E0D0A202020203C4865696768743E302E3070743C2F4865696768743E0D0A202020203C5072696E744F6E4669727374506167653E66616C73653C2F5072696E744F6E4669727374506167653E0D0A202020203C5072696E744F6E4C617374506167653E66616C73653C2F5072696E744F6E4C617374506167653E0D0A20203C2F506167654865616465723E0D0A20203C426F64793E0D0A202020203C5265706F72744974656D733E0D0A2020202020203C5461626C65204E616D653D225461626C6531223E0D0A20202020202020203C446174615365744E616D653E446174613C2F446174615365744E616D653E0D0A20202020202020203C4E6F526F77733E4E6F206F70656E204974656D73213C2F4E6F526F77733E0D0A20202020202020203C5374796C653E0D0A202020202020202020203C426F726465725374796C653E0D0A2020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A202020202020202020203C2F426F726465725374796C653E0D0A202020202020202020203C426F72646572436F6C6F72202F3E0D0A202020202020202020203C426F726465725769647468202F3E0D0A20202020202020203C2F5374796C653E0D0A20202020202020203C5461626C65436F6C756D6E733E0D0A202020202020202020203C5461626C65436F6C756D6E3E0D0A2020202020202020202020203C57696474683E312E3235696E3C2F57696474683E0D0A202020202020202020203C2F5461626C65436F6C756D6E3E0D0A202020202020202020203C5461626C65436F6C756D6E3E0D0A2020202020202020202020203C57696474683E36352E3370743C2F57696474683E0D0A202020202020202020203C2F5461626C65436F6C756D6E3E0D0A202020202020202020203C5461626C65436F6C756D6E3E0D0A2020202020202020202020203C57696474683E38362E3270743C2F57696474683E0D0A202020202020202020203C2F5461626C65436F6C756D6E3E0D0A202020202020202020203C5461626C65436F6C756D6E3E0D0A2020202020202020202020203C57696474683E3130362E3170743C2F57696474683E0D0A202020202020202020203C2F5461626C65436F6C756D6E3E0D0A202020202020202020203C5461626C65436F6C756D6E3E0D0A2020202020202020202020203C57696474683E3231372E3370743C2F57696474683E0D0A202020202020202020203C2F5461626C65436F6C756D6E3E0D0A202020202020202020203C5461626C65436F6C756D6E3E0D0A2020202020202020202020203C57696474683E3132362E3470743C2F57696474683E0D0A202020202020202020203C2F5461626C65436F6C756D6E3E0D0A202020202020202020203C5461626C65436F6C756D6E3E0D0A2020202020202020202020203C57696474683E33372E3670743C2F57696474683E0D0A202020202020202020203C2F5461626C65436F6C756D6E3E0D0A20202020202020203C2F5461626C65436F6C756D6E733E0D0A20202020202020203C44657461696C733E0D0A202020202020202020203C5461626C65526F77733E0D0A2020202020202020202020203C5461626C65526F773E0D0A20202020202020202020202020203C4865696768743E31352E3270743C2F4865696768743E0D0A20202020202020202020202020203C5461626C6543656C6C733E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F783233223E0D0A202020202020202020202020202020202020202020203C56616C75653E3D4669656C6473214163636F756E742E56616C75653C2F56616C75653E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E4E6F6E653C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D3E4E6F6E653C2F426F74746F6D3E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F726465725769647468202F3E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E4D6964646C653C2F566572746963616C416C69676E3E0D0A2020202020202020202020202020202020202020202020203C4261636B67726F756E64436F6C6F723E3D69696628526F774E756D626572284E6F7468696E6729204D6F6420322C20225768697465222C20224C696768746772657922293C2F4261636B67726F756E64436F6C6F723E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C466F6E7453697A653E3970743C2F466F6E7453697A653E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D224461746531223E0D0A202020202020202020202020202020202020202020203C56616C75653E3D4669656C64732144617465312E56616C75653C2F56616C75653E0D0A202020202020202020202020202020202020202020203C43616E47726F773E66616C73653C2F43616E47726F773E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D3E4E6F6E653C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F726465725769647468202F3E0D0A2020202020202020202020202020202020202020202020203C466F726D61743E797979792D4D4D2D64643C2F466F726D61743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E4D6964646C653C2F566572746963616C416C69676E3E0D0A2020202020202020202020202020202020202020202020203C4261636B67726F756E64436F6C6F723E3D69696628526F774E756D626572284E6F7468696E6729204D6F6420322C20225768697465222C20224C696768746772657922293C2F4261636B67726F756E64436F6C6F723E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C466F6E7453697A653E3970743C2F466F6E7453697A653E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D22526566223E0D0A202020202020202020202020202020202020202020203C56616C75653E3D4669656C6473215265662E56616C75653C2F56616C75653E0D0A202020202020202020202020202020202020202020203C43616E47726F773E747275653C2F43616E47726F773E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D3E4E6F6E653C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E4D6964646C653C2F566572746963616C416C69676E3E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F726465725769647468202F3E0D0A2020202020202020202020202020202020202020202020203C4261636B67726F756E64436F6C6F723E3D69696628526F774E756D626572284E6F7468696E6729204D6F6420322C20225768697465222C20224C696768746772657922293C2F4261636B67726F756E64436F6C6F723E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C466F6E7453697A653E3970743C2F466F6E7453697A653E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D22416D6F756E74223E0D0A202020202020202020202020202020202020202020203C56616C75653E3D4669656C647321416D6F756E742E56616C75653C2F56616C75653E0D0A202020202020202020202020202020202020202020203C43616E47726F773E66616C73653C2F43616E47726F773E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D3E4E6F6E653C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C50616464696E6752696768743E3070743C2F50616464696E6752696768743E0D0A2020202020202020202020202020202020202020202020203C54657874416C69676E3E52696768743C2F54657874416C69676E3E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E4D6964646C653C2F566572746963616C416C69676E3E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F726465725769647468202F3E0D0A2020202020202020202020202020202020202020202020203C466F726D61743E232C2323302E30303C2F466F726D61743E0D0A2020202020202020202020202020202020202020202020203C4261636B67726F756E64436F6C6F723E3D69696628526F774E756D626572284E6F7468696E6729204D6F6420322C20225768697465222C20224C696768746772657922293C2F4261636B67726F756E64436F6C6F723E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C466F6E7453697A653E3970743C2F466F6E7453697A653E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874223E0D0A202020202020202020202020202020202020202020203C56616C75653E3D4669656C647321546578742E56616C75653C2F56616C75653E0D0A202020202020202020202020202020202020202020203C43616E47726F773E747275653C2F43616E47726F773E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D3E4E6F6E653C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E4D6964646C653C2F566572746963616C416C69676E3E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F726465725769647468202F3E0D0A2020202020202020202020202020202020202020202020203C4261636B67726F756E64436F6C6F723E3D69696628526F774E756D626572284E6F7468696E6729204D6F6420322C20225768697465222C20224C696768746772657922293C2F4261636B67726F756E64436F6C6F723E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C466F6E7453697A653E3970743C2F466F6E7453697A653E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F783837223E0D0A202020202020202020202020202020202020202020203C56616C75653E3D4669656C6473214E6F7465732E56616C75653C2F56616C75653E0D0A202020202020202020202020202020202020202020203C5374796C6520786D6C6E733D22687474703A2F2F736368656D61732E6D6963726F736F66742E636F6D2F73716C7365727665722F7265706F7274696E672F323030352F30312F7265706F7274646566696E6974696F6E223E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D3E4E6F6E653C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F726465725769647468202F3E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E4D6964646C653C2F566572746963616C416C69676E3E0D0A2020202020202020202020202020202020202020202020203C4261636B67726F756E64436F6C6F723E3D69696628526F774E756D626572284E6F7468696E6729204D6F6420322C20225768697465222C20224C696768746772657922293C2F4261636B67726F756E64436F6C6F723E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C466F6E7453697A653E3970743C2F466F6E7453697A653E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F783134223E0D0A202020202020202020202020202020202020202020203C56616C75653E3D4669656C6473214578747261312E56616C75653C2F56616C75653E0D0A202020202020202020202020202020202020202020203C5374796C6520786D6C6E733D22687474703A2F2F736368656D61732E6D6963726F736F66742E636F6D2F73716C7365727665722F7265706F7274696E672F323030352F30312F7265706F7274646566696E6974696F6E223E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D3E4E6F6E653C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F726465725769647468202F3E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E4D6964646C653C2F566572746963616C416C69676E3E0D0A2020202020202020202020202020202020202020202020203C4261636B67726F756E64436F6C6F723E3D69696628526F774E756D626572284E6F7468696E6729204D6F6420322C20225768697465222C20224C696768746772657922293C2F4261636B67726F756E64436F6C6F723E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C466F6E7453697A653E3970743C2F466F6E7453697A653E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C43616E47726F773E747275653C2F43616E47726F773E0D0A202020202020202020202020202020202020202020203C43616E536872696E6B3E747275653C2F43616E536872696E6B3E0D0A202020202020202020202020202020202020202020203C5669736962696C6974793E0D0A2020202020202020202020202020202020202020202020203C48696464656E3E3D7B4578747261317D203D206E756C6C204F52207B4578747261317D203D22223C2F48696464656E3E0D0A202020202020202020202020202020202020202020203C2F5669736962696C6974793E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A20202020202020202020202020203C2F5461626C6543656C6C733E0D0A2020202020202020202020203C2F5461626C65526F773E0D0A202020202020202020203C2F5461626C65526F77733E0D0A202020202020202020203C536F7274696E673E0D0A2020202020202020202020203C536F727442793E0D0A20202020202020202020202020203C536F727445787072657373696F6E3E3D7B53416D6F756E747D3C2F536F727445787072657373696F6E3E0D0A20202020202020202020202020203C446972656374696F6E3E417363656E64696E673C2F446972656374696F6E3E0D0A2020202020202020202020203C2F536F727442793E0D0A202020202020202020203C2F536F7274696E673E0D0A20202020202020203C2F44657461696C733E0D0A20202020202020203C4C6566743E302E3870743C2F4C6566743E0D0A20202020202020203C546F703E31322E3070743C2F546F703E0D0A20202020202020203C4865616465723E0D0A202020202020202020203C5461626C65526F77733E0D0A2020202020202020202020203C5461626C65526F773E0D0A20202020202020202020202020203C4865696768743E31362E3870743C2F4865696768743E0D0A20202020202020202020202020203C5461626C6543656C6C733E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F7838223E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F7264657257696474683E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D203E3270743C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F7264657257696474683E0D0A2020202020202020202020202020202020202020202020203C466F6E745765696768743E426F6C643C2F466F6E745765696768743E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E546F703C2F566572746963616C416C69676E3E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C56616C75653E6C616E674163636F756E745F3C2F56616C75653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F7839223E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F7264657257696474683E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D203E3270743C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F7264657257696474683E0D0A2020202020202020202020202020202020202020202020203C466F6E745765696768743E426F6C643C2F466F6E745765696768743E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E546F703C2F566572746963616C416C69676E3E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C56616C75653E6C616E67446174655F3C2F56616C75653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F783130223E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F7264657257696474683E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D203E3270743C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F7264657257696474683E0D0A2020202020202020202020202020202020202020202020203C466F6E745765696768743E426F6C643C2F466F6E745765696768743E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E546F703C2F566572746963616C416C69676E3E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C56616C75653E5265663C2F56616C75653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F783131223E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F7264657257696474683E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D203E3270743C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F7264657257696474683E0D0A2020202020202020202020202020202020202020202020203C466F6E745765696768743E426F6C643C2F466F6E745765696768743E0D0A2020202020202020202020202020202020202020202020203C54657874416C69676E3E52696768743C2F54657874416C69676E3E0D0A2020202020202020202020202020202020202020202020203C50616464696E6752696768743E3270743C2F50616464696E6752696768743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E546F703C2F566572746963616C416C69676E3E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C56616C75653E6C616E67416D6F756E745F3C2F56616C75653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F783132223E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F7264657257696474683E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D203E3270743C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F7264657257696474683E0D0A2020202020202020202020202020202020202020202020203C466F6E745765696768743E426F6C643C2F466F6E745765696768743E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E546F703C2F566572746963616C416C69676E3E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C56616C75653E546578743C2F56616C75653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F783133223E0D0A202020202020202020202020202020202020202020203C5374796C653E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F7264657257696474683E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D203E3270743C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F7264657257696474683E0D0A2020202020202020202020202020202020202020202020203C466F6E745765696768743E426F6C643C2F466F6E745765696768743E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E546F703C2F566572746963616C416C69676E3E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C56616C75653E4E6F742E3C2F56616C75653E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A202020202020202020202020202020203C5461626C6543656C6C3E0D0A2020202020202020202020202020202020203C5265706F72744974656D733E0D0A20202020202020202020202020202020202020203C54657874626F78204E616D653D2254657874626F7837223E0D0A202020202020202020202020202020202020202020203C56616C75653E4B53543C2F56616C75653E0D0A202020202020202020202020202020202020202020203C5374796C6520786D6C6E733D22687474703A2F2F736368656D61732E6D6963726F736F66742E636F6D2F73716C7365727665722F7265706F7274696E672F323030352F30312F7265706F7274646566696E6974696F6E223E0D0A2020202020202020202020202020202020202020202020203C426F726465725374796C653E0D0A20202020202020202020202020202020202020202020202020203C44656661756C743E536F6C69643C2F44656661756C743E0D0A20202020202020202020202020202020202020202020202020203C4C6566743E4E6F6E653C2F4C6566743E0D0A20202020202020202020202020202020202020202020202020203C52696768743E4E6F6E653C2F52696768743E0D0A20202020202020202020202020202020202020202020202020203C546F703E4E6F6E653C2F546F703E0D0A2020202020202020202020202020202020202020202020203C2F426F726465725374796C653E0D0A2020202020202020202020202020202020202020202020203C466F6E7446616D696C793E417269616C3C2F466F6E7446616D696C793E0D0A2020202020202020202020202020202020202020202020203C426F72646572436F6C6F72202F3E0D0A2020202020202020202020202020202020202020202020203C426F7264657257696474683E0D0A20202020202020202020202020202020202020202020202020203C426F74746F6D203E3270743C2F426F74746F6D3E0D0A2020202020202020202020202020202020202020202020203C2F426F7264657257696474683E0D0A2020202020202020202020202020202020202020202020203C466F6E745765696768743E426F6C643C2F466F6E745765696768743E0D0A2020202020202020202020202020202020202020202020203C50616464696E674C6566743E3270743C2F50616464696E674C6566743E0D0A2020202020202020202020202020202020202020202020203C566572746963616C416C69676E3E546F703C2F566572746963616C416C69676E3E0D0A202020202020202020202020202020202020202020203C2F5374796C653E0D0A202020202020202020202020202020202020202020203C5669736962696C6974793E0D0A2020202020202020202020202020202020202020202020203C48696464656E3E3D7B4578747261317D203D206E756C6C204F52207B4578747261317D203D22223C2F48696464656E3E0D0A202020202020202020202020202020202020202020203C2F5669736962696C6974793E0D0A20202020202020202020202020202020202020203C2F54657874626F783E0D0A2020202020202020202020202020202020203C2F5265706F72744974656D733E0D0A202020202020202020202020202020203C2F5461626C6543656C6C3E0D0A20202020202020202020202020203C2F5461626C6543656C6C733E0D0A2020202020202020202020203C2F5461626C65526F773E0D0A202020202020202020203C2F5461626C65526F77733E0D0A20202020202020203C2F4865616465723E0D0A20202020202020203C57696474683E3131696E3C2F57696474683E0D0A20202020202020203C4865696768743E382E35696E3C2F4865696768743E0D0A2020202020203C2F5461626C653E0D0A202020203C2F5265706F72744974656D733E0D0A202020203C4865696768743E35352E3770743C2F4865696768743E0D0A202020203C436F6C756D6E733E313C2F436F6C756D6E733E0D0A20203C2F426F64793E0D0A20203C50616765466F6F7465723E0D0A202020203C4865696768743E302E3070743C2F4865696768743E0D0A202020203C5072696E744F6E4669727374506167653E66616C73653C2F5072696E744F6E4669727374506167653E0D0A202020203C5072696E744F6E4C617374506167653E66616C73653C2F5072696E744F6E4C617374506167653E0D0A20203C2F50616765466F6F7465723E0D0A20203C44617461456C656D656E744E616D653E5265706F72743C2F44617461456C656D656E744E616D653E0D0A20203C44617461456C656D656E745374796C653E4174747269627574654E6F726D616C3C2F44617461456C656D656E745374796C653E0D0A20203C456D626564646564496D616765733E0D0A202020203C456D626564646564496D616765204E616D653D22656D626564646564696D61676531223E0D0A2020202020203C4D494D45547970653E696D6167652F706E673C2F4D494D45547970653E0D0A2020202020203C496D616765446174613E6956424F5277304B47676F414141414E5355684555674141414C4541414142544341494141414266783345624141414141584E535230494172733463365141414141526E51553142414143786A777638595155414141414A6345685A6377414144734941414137434152556F536F4141414267335355524256486865375A324A6D787A46656362356D32494D6D4D5047594442584D43474F4454613269554D494F4D5378446346586A475048385945647830644D6A465A49516863434359514F684F356271395871586D6C31724B5339372F75635865334F6275565838395755617172366D423274447178356E2F645A7A5652563933525876663064316457746D325A6D56426C6C754C68704E444D78486568694A6F2F49727838356D4B4E5068476D6168796D6469314D324F35715A6D5A36656E736F6A6D383379315A6162706E6C5161443564486D542F356B7652304861436A59526C6C4146754D762F6D4D444375326F654C596B64514975776556554D544B6A4F707871646953653349525455327153617A4B6A75742F2F4B5644646D6E533071473256562B71346B704E545774736A4E714F6B632B61453772776F6E73705A3137354C6334486E626C4857634355302F423232646B65326E544E5A766644526E753266363037614C777039316D3367376A364D466F67714E2F65725836324F747A77492F504B356133564B68624B2F5266506E73374562714E6F625233656474382F64647246744C62625371397A534E5A5448753354576E306469684D625342306D79587A736264553434414951634E6F346F554E75753731513736437976794C5A32577A756E2B4A2B7365314967514E6F346D2F58713665584355665A34337339457848333168447833427A3930674745312F475277334C6139546E336A4B667753564E504C744F5073344F4535505A725964623374396262376D2F746E4F59594B474D6A7737576E5A3154545A7871366E63464956785832644455465951755A56797663445642376E71356D6A6852332B734A77684A765968726C30447330546B6C54313867596B58455A3178506D57424E642F526C5043705A72397A56594A334B7173634363374B2F74474271394B46566C5848504D7353624176704D64376E6937504871755239717333392F6F566147592B765968716231713246436E3879354F3967596B7963587A3639583550744D564C7444456F334F7269597554325732465961626C74694D7430756244413031656C64435678646D576758306E4F6A41684639714870724C2B644F2F6C343043722B7475336F7A766C52734446724E726470432B4A336A4654596F456D45494267626A51426B41566A3659303333487569585272554E76523556634B316C51326A3439712F4E48594F752B566F6950785774703072764C4242486530776E3239597A442B69466834316E793163545578505436646F6F7170462F5871662B6F38643668643731506F364E546875796950424B434B434E666C783358366B64576A4D424131633931374B616F6C636146415446617565617832557A5148364852695A474D36556E75586130335A7863536F6278327832317265417071646E4F4E4F703257384973726C742B57752B58786B636174656A36634856424B636471346D70616657646A51557A6F50415438395850392B6A6245416E67784559796B2B486B31656A34314F5A447A64366F77774F6E7536687437683778796F577433534F7965575865446D303531454C2B556B4C5052577143744E6E2B566B674F2B4E445A3775496E346F3664373247725464584E35767473494666467A6D4E743576755651616F6D7071616D596A5878396B6C66454A59504C314E6E6530327A5751455855333236792F61343845797A6E6D72484447772F32757056775131566A5A504955366B312B77724B4D556853586A784B30495151527A5A59584A62304636364A6C376634556E42357A364B43757962675A4C643664612F3630586231306D6231757970314C6A3655367830615033696D43316343547A623059572B6C484F757949536F5562636D5A436A724C4B393931764731576C6A5A4245337471326A76374D79377867345336317439686E464374325359652B4545457361756B63663049614F4B483233776465507A4B652F7165745742506B376F6C75424833386D62566D7A454E69675478782B6144766E39703674527A5834795156773550314D386969306A515250555A376239436F41506B4B372B46647A4F6C5677596641553273507532506363683965527635355866394B754744533156396F546B427547644D5174776C6A6B6334556439725454703265344973697642745A6D62484D642B35724E3358634C466F44314B434A6742655133357256766F724164654A4A69596E4A324D31775541387673496659342F2F64394130766E2B4A5832583530444B39564564412B476B6E7542694D716C4F64585150526C6F5357475043326E6C464345464F6B315068462F3334623749375A51346A534E4445786D5A55664F70616666305054353973474C37514E366A51684F334F3671582F62345A596A64627132657A42445658697668777541517334584B376A705948506C79593536505164546346584561514C62795436686C357A334447614F6E75765A6362523159335554735441374A352B336A6A674F715A71596D4A694931515334304B2F7566644D665935654C38706E754E7A2F3071317A2B644B6470526A67702F65735334317838316F63566F534E7376496D646B4F6D4E596C43614A736247702B533361693659754C706E6346782B656E6A73497147753144496B5642322F6F4D655634454E61436A434B74706C4C68742F6D36694253453654666B7177525049336C3078394D70767851534834494555757A534B5271596E52304E456B546F486B7731692F6374554331357A30735473537264556B474F354937642F493637787945684869754B2B47616F41736745536764616B6F646A462B63617534617157735A3645394F697774526D696149634F5567362F4B544A56595442303533536857684D526B485661456D434579334854473237666A3558713731397434784F364B6B576A5A7944545742484C4542464C4A44624B51705665706336364273667153756D34436471364B7A6632782F72546B59646D37615253465645356C4D4A6B5554674D466163385A58426D376C574F4763494C2F6B4E76416F7553746D566F34374A4432533234302F5559464A4F4E5859502F75317878456F51524E30743532567437647A52524E4337376F4D4E53476D63633365657679674B637142555A5139494734703854535275576745675A31774255465869414D4E3478764F6776497468356F5475697456452B6E7A6D433736783158546F4F6F6356594D544559753843665869306C645345676B70364F49312B2F5159684F53796B7A4E482B313456724437645A6338544C3137584D6B69503444356E4E5557526F416D38386F5732495A646369787A4A326C777446444D67734A6F674D76414F494E514562536768674444664866436A564E6E4C327455455962584D317243353631384157766D67716E48392F67696E4B666348317538334D7A7152534E55456D49556D5573476F726178563977516879472F336D77624175326E7555713459427473724635357136706339754373324F502F366A6D4A7672695A6F49706D483637726479516D7243644A6A5535534870776D627337515747676B42353074736850376B713955456D5A525941757845386445534F4A757A536576324E37694275596335316F52654F7839766C437A474A6E55652B2F4A6D76634D584E366B507A356C794158314C463074506553534D6F4948745234385945706C6A44754D31656A6242576C6F6B61494A2B4A434E674C426B4D793930454E50563952486D6D61523557452F68795535534870776D6B4943324C47567252424C2B372F59684A755356755451425A4274324674726A534D4B566967362B344A6A70483150653271507357717A7665304666387252563679662F624A2F5854467063444C4C4E3367654A78427955517A6664735342474E7A4239374C476279494545544354466D434B754A554336654A6B67347057583470463049305952514569762B456E6159616766734454654236346C3078466457457A316A366F476C42563741386E4E7671654D70496B3442305150716C765361763232396C36777235787935546B64573650514E54336A6C777643713954446E6D676876677352706F68677A5A6A564246744D374F4337542F4F7A4B6D397A6A4B39474A744D7731614D62756B684E686B79516675624B612B4D6C4F58776F75795441726733733957792B6F7633396633626C4138386C56617635682F5542534365444D7738535630464A714933506156457437395456686651664A7335516B514453786F61705256695869455754623273594345396A5159585257633648583236326B7A566457452F6376396E5867386536464F67327865502B4D756A6C6F513869356F3845306D4332776E4874713949494D724B6965327370664D61516578474C534E5A6145364649626836757669623568307A4A797570624D6E4C4F6F625453787334307835537647556959324F4D4A525A31577A7246334373707276446954764B45305464753064534E4C454A78663641787A537A6C4579586F5164587130516F617734615A705A6441396B4D486F4D4270325350505645373454334A4A4546686F457573497A734A68645858784E4158494362796772517430772F6B4378496961634A67446555694B47797473503267455367354D6E7931595863727275796D76696E6466376F68727872675A365A414E326A6670584C6D2B63564F4A72774A7566756D766268776B5338474743637951345956346168372F714C4A34436B3175544D586B41714F546B6D3045375568706F416472624733705756744973737962744D6D6A71484A544B39544E2B422B4A49307366476350375352374D67643765686B684F4E772B6568796F7836752B33415A4E3252343267747638394350644D714230353359457075566C4978726F676E736D64694444366F6143515777694D53504E6E575371466B5171596D7869536E70717738504E45336D31693054547470744F51416B31544F5949634243586A492F786763756C62693159616D61534A6E4852496A667A4431626E45414D7748432B5A3535367A362F317544305857484365636C5968313159325744396975384F534D352F56784B57486136494A51444D45495A75344A4652434D615A526A436141765345672B54593959472B67754D522B6F494F312B6579554935484E505679754A67426E2F637761663268647676434261516C533759704D614F4A4B3761474878462B4B5553544C384B6F673353484C4B5154456274747A325778566253655869796D4E5161516D366C6F477A6A5150754A6C774B6841726D3044334E6F5367717A394465666A637973526B6C6838697763626D627A33636772684A4B7A7A6A7A376D774C5847692B5A37483950544D326478423868635453776D7959472B49414D4E41643245774F48375A4731486177624E64784B46785A3553716961513175686154302B7150422F536248727742686D776C6A7350697055312B47356576376A504E37453238534D726F7874307732335738545149754F6F764D7A61326964365458496847706961754D2B4B4D72425358734C565554536575735048534F364C64545050322B7A69337658715365574B586D48544A337746316B707049693030336E54544D63684152456B55514E744F6E6F4D33634F5138714E6871477869466C776B7047346E726F654E48484E4D5A65614B4235342F44395636786B74547843454A75364D484D62514730354C7964793434734F316D6349746833514F67785078796F58654A49394657525067326D684330446D714B673672353962703263787672466572546846476D436F4C4273386254714739315A6C674B695346327847312F42384C46506C6F55466B5449465554536573787277345964574975643053394E5665523737654133626D5967306A4B4B7864475274316C5459413573785074492B715865395866724E435432513875315248446F714F7154772F4B48494478377830615039633669446470312F477A48773451623376426831324141794C5834477737584A414E43737161414B6D61534A6D7A456D79725633666D62705237764F4D4E7465523455756A624E4B69506F4C5A624235365843564C38413663375A6458542B76324E38735348674C416A664C59733874354857524D6756524D6752524E6E6539567446623461584C36387863784F756A6A65715A355965616B4E653368707336704C582B4751416F616675444A6372733533386E575A66524B5766556363356B41544C79624F4E776A7472494D415159524A42377874766C365A462B4A6F68313632382F527139533862314E4C6A6C7834476D53306D4A724D58326F6249575842446B5938356C445542556A57524D6F394A78387279716D5465504B2F676B654B764A4D3577657A644974317A77332B353531774C39617235496A315466727A315279666339356C5954484D6235506D3338374E542B4E51466A314457715476656F356945397535694B5645326B35423263746A746143667A3562724D4A56376C583566475765587063425A7850334471756E2B3471694652364D2B70722B646638336C716876722F566E7A38744271456D384872662F4644377456426E5A4D362F327174726637684E763633597864356D2F595A526A755376637554443139666F714D744439366A65484C3537797052342B505A4758537633716859654E5930542B442F4F556D63776D64587A797738744D3463423731796758746C52734B496C524B6F6D30702F357557655247596C6B6676357430373535304B384B53646F6961427A777131792B667367304135797156337633496C565675463569634F546972754E74473675623970356F622B776344764F5855424E63574E4B566F6350363332706464557546666A7A61676A3253634745585A517777615A39636144357A534B3956462B69594546757150724E59767741374244756E5671712B743955305469444B732B43416E3337666C482B3851766347726C6D2B33723945502B4D666831524E6A492B5070326A695239734C52694B4F3949344131584D64653755684D585367506C4554644E6C357377524A6654704B6D7266505638656335586265504D664F593633655378654C313854624A30332F32736C3441586D576C4B4E526532774E412B6F2F64356C795A4746684E51462F5632554B586269614F4E536D483679792F4F34575859554933454B72546737376979743141365377717459594F577A65376962312B4E75362F464D4C59392F316B4B714A39467930726A66694A514968635145577A362F3361304E2B554B6462636D36334A385972644C30674C766435614B6E706B636A37373575716D796E503755436A534533736239476A78633639397A36314461746263396669373676386341667A6746576A696F7656686C616943514979374D716E3331546477514A7356784D65336A796D71384C4245377832554E666574564364386C6476365A644C6956776952784F6B61674B6B61414C4D4F317777444A4838392B326D4D55682B646C53342B7252702F4B2B4A44782B6A642B6E397A372F6A56316B79516D4230664E49546848446E4D584D544652536A69635A4262656F70784542364F54624F6D2F496E56756B6E376B4E6B5A2F54695A4270674D7753696963387530656B3648304A54555A6F6D786962565A35667132715531707354446953366A61652F68545547634A6F70646579656752332B3574324159504A4A3565692B5A6543584E34396A337A3157312B46556578517A386F636F767430513345316B396465484F5437693071786C534E64475855592B7430435545644E37545465674B5030335631694357744344327041476D5175626F7243626168335568766351484636567041676442316231765274772F7368445834383052434F4930556372377476466E6B6538646F454E3342737579755A4C2B2B514F2F7065586A4B335447596647442B4266696B4B624B52556B736E65426C4475646575426A33654A6C64395A53734354374C6866375639794C53454479437449786636616A74436E45507A53544573356F41704178382F6B6C2B50624F674E453338706C4A582F537966364556695135317538336676524B543063324D6E4C4C42614B3276314C652B486C2B6D4C35736C562B6C524A6A694E4246314D6278694A30712F6577454C754E6D394A34786F6D306C352F7761793233584E414E526A4B54397046666A2F49596272496D694633342F4B6C4630576545656144324379764E317A69387345453357337457663359317754374A5545675157707756574B5670416D394C315874353578754A756A3764426773617A70334D545478784F53416D667A562F3834784D2B7363372F44656A435A4446393766364930332B346E6E455838573473445035554F743857385279506469616534513351524E2F794D554B6B4C31354437674B4349436F74566C30484C42354E4B733472442B376D67422F7A67574772716B6F54524E6658613272717631566D7756676E37516874725576434C46493155525239384375476736323661563739797A536D65317A36364C6665627630754F39456E6E582B677870516B31736C363148652B684F6E43646B507579574D344373785A7668714E67776B5654524942714B6E325A397947616D6E43594B4D4235647062336779767879344E45305135464C6C4A754568634D32634563306B35336478376533456C5142326D417552654158332F39764B434E2B507458446A7A593356546249384F6B34547772566E39474F4D2B41342B45314E37494A7969334A30316973523363314E50386B6F6E54784E6757593075655847542B5671614A6A6747716F686E457A41346F6475772F3941507A72306D2B736431334573485957447265694E436D4F73456D596D704D3033394238393059546273632F344A6D75444B6C6E50425430747631685265694C736164626B626945564335685A6C6E6A7655784D5355447538783661647A7A7134305462793057566652494146484F6E53622B786237732F4A674C6A58524D365A647668637A50724A4D617A38684B514B597967564864484C506156533346765547697975454F4531496A436B677A53466F6F424333545A526A77656C6A39694F765041743251677A4574716742684A6F4136334D5A67585231615A71514B6F4C5A4249684263762F624E34733530385335506E317572687063636E48515A5347344C483451524936504C492B34585351677A6350714D6867637A505072745174334A69463934444C374D6B6D5A595968694E414734694F574F786C736E54496E67792B2F7177766C487A4E63515A455930654743707962516A4E63483138365863666F36306C36694A6D69356478625A783738506E716E737939784F52746D5275596B774F6D6C70766144302B76714B675777582F74746C765A6B6D6136746B4C6B76747755707A667452475A6855776B6B326A52344C594B665863524C31594D697451452B50552B5855366F322B6E4537652F6B77737837332F536E6E675149394C3763704E61432F497834704359416F5142482F7258564A5772437167717A48516C4A6B573664483546306746524E464C55656B314466446C4943765A6A38514B7666774B4E3933366F67376C644942396956693858482F4461666D4B39446E46515572346E2B6A4A6B2F70742B74646A466178424D5550724E577452624B6F6D5045544274674261334A6A4E4D454944715749366642624455424D4C546F3657507A39505332477A4677715075617A613161397831694C6C493155645337454F304A70484B76633173352B58306D455066734A6C52507276496257474953334B6D65794355584E372B7558585579697463453246436E4F353161596D714C4D37336165464249762F2B6D55732B564D547A59764C747A325172796466506E42453263366A45376879566F4176792B796D794F7A6542793469417844392F4A4C59716A6B4E776B3871594D534E5845794D68497569596937314E486B6D764667724441717733354430357146376B4D32504B3539615A5A373568665A636D514E4A72333245526A567072414B2F4F6A31443638724B422F61377631666D5138584E362F784A3968533941455950786B7739493051636A797870464C4B7A6C637672776C36643141715A6F594868354F31305479614C6D383434314C6155586332336339306E4743564F584A4A596944393870647571494D455771436E69556E77686D464F52746F474E43317344362F56454A41506C4A78574439456A366541584B6C2F506854782F3977774D477A7242616F575744375A4F626F4D51535A4D31653547387A554F684D4F76374E4433376552497672585254504D6E494655543657747177474E762B56326651507651522F4C44784A5A3258647258307A79554C4F386A4645316573334F6863507863684A7134415A477169614B654177767652435451576B4A535A4B38716B765079432B7865712F6172504834702F392B7066794E787A5936375973394457524D6754684E324F71346F5465786F385073396A6F38734D3575413772475542304F455745674254735262774F33786762786A4A703779716C782B4B3935396C445542346A52683130385570516D63376C50464251656B39533549683777474964326F2F73654A62334633353555546C76633976647130436345355874743139396344754D4B544E5648733836493461584977722F6339456D4236362B744A364A4D6A7A6673574634543042475750786B2B4F4555356264493747766D4D7649637A38343447434E625133494C4C5465705444743571576F676C777546327667664147774A4B6B6949512B4243456E6359445832484A6A73464942442F4A677A424D6642777458444A7A74565A2B4A5776653150476156497342496647476C766B726F6768755447464737584E51465662507A48525A74772F6F2B622F68794F79355A65586C5A4A444A54656C6D4E6E6E647A4E726E396A64676E595872472F4163532B55556269727267654A374E5058746A2B63544B364B7A5341724F45614A44466A556C765274674354566A58504459324E67744E434D6A6146782F5876703938354765373954717A79466B5844347A6677714E36375368636344547037714C67524A663637306F746A6C2F73695635635931485A6F763572743736447A503548697A69534D6B4B674351516753506E2F774D7134516542714170513155555A5A453255454B47756944422F526D6E6A7150623161685069786A42734E32576D396B752B4C2B5673486C2B596E79464C755871676E707241575A64355178454C63556E46705165536C393953416758483974424E6D704D77626A65356A494A665759355A526871437369544A386C445652686F2B7071616E2F4238584537496650693072474141414141456C46546B5375516D43433C2F496D616765446174613E0D0A202020203C2F456D626564646564496D6167653E0D0A20203C2F456D626564646564496D616765733E0D0A20203C44617461536F75726365733E0D0A202020203C44617461536F75726365204E616D653D22445331223E0D0A2020202020203C436F6E6E656374696F6E50726F706572746965733E0D0A20202020202020203C4461746150726F76696465723E53514C3C2F4461746150726F76696465723E0D0A20202020202020203C436F6E6E656374537472696E673E5365727665723D286C6F63616C295C53716C657870726573733B44617461426173653D707269636B616B6F6E746F3B696E74656772617465642073656375726974793D737370693B436F6E6E6563742054696D656F75743D35393C2F436F6E6E656374537472696E673E0D0A20202020202020203C496E746567726174656453656375726974793E66616C73653C2F496E746567726174656453656375726974793E0D0A2020202020203C2F436F6E6E656374696F6E50726F706572746965733E0D0A202020203C2F44617461536F757263653E0D0A20203C2F44617461536F75726365733E0D0A20203C5265706F7274506172616D65746572733E0D0A202020203C5265706F7274506172616D65746572204E616D653D22706172616D4D756C74695265636F6E47726F757049445F223E0D0A2020202020203C44617461547970653E496E74656765723C2F44617461547970653E0D0A2020202020203C44656661756C7456616C75653E0D0A20202020202020203C56616C7565733E0D0A202020202020202020203C56616C75653E313C2F56616C75653E0D0A20202020202020203C2F56616C7565733E0D0A2020202020203C2F44656661756C7456616C75653E0D0A2020202020203C4E756C6C61626C653E747275653C2F4E756C6C61626C653E0D0A2020202020203C416C6C6F77426C616E6B3E66616C73653C2F416C6C6F77426C616E6B3E0D0A2020202020203C4D756C746956616C75653E747275653C2F4D756C746956616C75653E0D0A2020202020203C50726F6D70743E47727570702049443C2F50726F6D70743E0D0A202020203C2F5265706F7274506172616D657465723E0D0A20203C2F5265706F7274506172616D65746572733E0D0A20203C436F64654D6F64756C65733E0D0A202020203C436F64654D6F64756C653E52646C456E67696E652E646C6C3C2F436F64654D6F64756C653E0D0A20203C2F436F64654D6F64756C65733E0D0A3C2F5265706F72743E, N'subOpenItems.rdl', NULL, N'', NULL, N'', N'', N'<Settings>
  <xs:schema id="Settings" xmlns="" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msdata="urn:schemas-microsoft-com:xml-msdata">
    <xs:element name="Settings" msdata:IsDataSet="true" msdata:UseCurrentLocale="true">
      <xs:complexType>
        <xs:choice minOccurs="0" maxOccurs="unbounded">
          <xs:element name="Parameters">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="ParamName" type="xs:string" minOccurs="0" />
                <xs:element name="ParamType" type="xs:string" minOccurs="0" />
                <xs:element name="DefaultValue" type="xs:string" minOccurs="0" />
                <xs:element name="Prompt" type="xs:string" minOccurs="0" />
                <xs:element name="SaveLastEnteredValue" type="xs:boolean" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
          <xs:element name="dtExportSettings">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="PDF" type="xs:boolean" minOccurs="0" />
                <xs:element name="TIF" type="xs:boolean" minOccurs="0" />
                <xs:element name="HTML" type="xs:boolean" minOccurs="0" />
                <xs:element name="Word" type="xs:boolean" minOccurs="0" />
                <xs:element name="RTF" type="xs:boolean" minOccurs="0" />
                <xs:element name="XML" type="xs:boolean" minOccurs="0" />
                <xs:element name="MHT" type="xs:boolean" minOccurs="0" />
                <xs:element name="Excel" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLSX" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLS" type="xs:boolean" minOccurs="0" />
                <xs:element name="Text" type="xs:boolean" minOccurs="0" />
                <xs:element name="Delimiter" type="xs:string" minOccurs="0" />
                <xs:element name="Wrapper" type="xs:string" minOccurs="0" />
                <xs:element name="Extension" type="xs:string" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
        </xs:choice>
      </xs:complexType>
    </xs:element>
  </xs:schema>
  <Parameters>
    <ParamName>paramMultiReconGroupID_</ParamName>
    <ParamType>Integer</ParamType>
    <DefaultValue>1</DefaultValue>
    <Prompt>Multi</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <Parameters>
    <ParamName>paramDateTo_</ParamName>
    <ParamType>DateTime</ParamType>
    <Prompt>langPrintDate_</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <dtExportSettings>
    <PDF>true</PDF>
    <TIF>true</TIF>
    <HTML>false</HTML>
    <Word>false</Word>
    <RTF>false</RTF>
    <XML>false</XML>
    <MHT>false</MHT>
    <Excel>false</Excel>
    <XLSX>false</XLSX>
    <XLS>true</XLS>
    <Text>false</Text>
    <Delimiter xml:space="preserve">	</Delimiter>
    <Wrapper />
    <Extension>txt</Extension>
  </dtExportSettings>
</Settings>', 0, 1, CAST(N'2014-09-29T07:52:56.803' AS DateTime))
INSERT [dbo].[Reports] ([ReportID], [ReportName], [ReportType], [FileA], [FileAFileName], [FileB], [FileBFileName], [FileC], [FileCFileName], [FileD], [FileDFileName], [Rights], [Settings], [IsDefault], [Enable], [ModifiedDate]) VALUES (2, N'langOpenItemsBank_', 1, 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, N'OpenItemsBank.rdl', 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, N'subOpenItemsBank.rdl', NULL, N'', NULL, N'', N'', N'<Settings>
  <xs:schema id="Settings" xmlns="" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msdata="urn:schemas-microsoft-com:xml-msdata">
    <xs:element name="Settings" msdata:IsDataSet="true" msdata:UseCurrentLocale="true">
      <xs:complexType>
        <xs:choice minOccurs="0" maxOccurs="unbounded">
          <xs:element name="Parameters">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="ParamName" type="xs:string" minOccurs="0" />
                <xs:element name="ParamType" type="xs:string" minOccurs="0" />
                <xs:element name="DefaultValue" type="xs:string" minOccurs="0" />
                <xs:element name="Prompt" type="xs:string" minOccurs="0" />
                <xs:element name="SaveLastEnteredValue" type="xs:boolean" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
          <xs:element name="dtExportSettings">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="PDF" type="xs:boolean" minOccurs="0" />
                <xs:element name="TIF" type="xs:boolean" minOccurs="0" />
                <xs:element name="HTML" type="xs:boolean" minOccurs="0" />
                <xs:element name="Word" type="xs:boolean" minOccurs="0" />
                <xs:element name="RTF" type="xs:boolean" minOccurs="0" />
                <xs:element name="XML" type="xs:boolean" minOccurs="0" />
                <xs:element name="MHT" type="xs:boolean" minOccurs="0" />
                <xs:element name="Excel" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLSX" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLS" type="xs:boolean" minOccurs="0" />
                <xs:element name="Text" type="xs:boolean" minOccurs="0" />
                <xs:element name="Delimiter" type="xs:string" minOccurs="0" />
                <xs:element name="Wrapper" type="xs:string" minOccurs="0" />
                <xs:element name="Extension" type="xs:string" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
        </xs:choice>
      </xs:complexType>
    </xs:element>
  </xs:schema>
  <Parameters>
    <ParamName>paramMultiReconGroupID_</ParamName>
    <ParamType>Integer</ParamType>
    <DefaultValue>1</DefaultValue>
    <Prompt>Grupp ID</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <Parameters>
    <ParamName>paramDateTo_</ParamName>
    <ParamType>DateTime</ParamType>
    <Prompt>langPrintDate_</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <dtExportSettings>
    <PDF>true</PDF>
    <TIF>true</TIF>
    <HTML>false</HTML>
    <Word>false</Word>
    <RTF>false</RTF>
    <XML>false</XML>
    <MHT>false</MHT>
    <Excel>false</Excel>
    <XLSX>false</XLSX>
    <XLS>true</XLS>
    <Text>false</Text>
    <Delimiter xml:space="preserve">	</Delimiter>
    <Wrapper />
    <Extension>txt</Extension>
  </dtExportSettings>
</Settings>', 0, 1, CAST(N'2014-09-29T07:53:42.883' AS DateTime))
INSERT [dbo].[Reports] ([ReportID], [ReportName], [ReportType], [FileA], [FileAFileName], [FileB], [FileBFileName], [FileC], [FileCFileName], [FileD], [FileDFileName], [Rights], [Settings], [IsDefault], [Enable], [ModifiedDate]) VALUES (3, N'langBalanceReport_', 1, 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, N'BalanceReport.rdl', NULL, N'', NULL, N'', NULL, N'', N'', N'<Settings>
  <xs:schema id="Settings" xmlns="" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msdata="urn:schemas-microsoft-com:xml-msdata">
    <xs:element name="Settings" msdata:IsDataSet="true" msdata:UseCurrentLocale="true">
      <xs:complexType>
        <xs:choice minOccurs="0" maxOccurs="unbounded">
          <xs:element name="Parameters">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="ParamName" type="xs:string" minOccurs="0" />
                <xs:element name="ParamType" type="xs:string" minOccurs="0" />
                <xs:element name="DefaultValue" type="xs:string" minOccurs="0" />
                <xs:element name="Prompt" type="xs:string" minOccurs="0" />
                <xs:element name="SaveLastEnteredValue" type="xs:boolean" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
          <xs:element name="dtExportSettings">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="PDF" type="xs:boolean" minOccurs="0" />
                <xs:element name="TIF" type="xs:boolean" minOccurs="0" />
                <xs:element name="HTML" type="xs:boolean" minOccurs="0" />
                <xs:element name="Word" type="xs:boolean" minOccurs="0" />
                <xs:element name="RTF" type="xs:boolean" minOccurs="0" />
                <xs:element name="XML" type="xs:boolean" minOccurs="0" />
                <xs:element name="MHT" type="xs:boolean" minOccurs="0" />
                <xs:element name="Excel" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLSX" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLS" type="xs:boolean" minOccurs="0" />
                <xs:element name="Text" type="xs:boolean" minOccurs="0" />
                <xs:element name="Delimiter" type="xs:string" minOccurs="0" />
                <xs:element name="Wrapper" type="xs:string" minOccurs="0" />
                <xs:element name="Extension" type="xs:string" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
        </xs:choice>
      </xs:complexType>
    </xs:element>
  </xs:schema>
  <Parameters>
    <ParamName>paramMultiReconGroupID_</ParamName>
    <ParamType>Integer</ParamType>
    <DefaultValue>1</DefaultValue>
    <Prompt>Multi</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <Parameters>
    <ParamName>paramDateTo_</ParamName>
    <ParamType>DateTime</ParamType>
    <Prompt>langPrintDate_</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <dtExportSettings>
    <PDF>true</PDF>
    <TIF>true</TIF>
    <HTML>false</HTML>
    <Word>false</Word>
    <RTF>false</RTF>
    <XML>false</XML>
    <MHT>false</MHT>
    <Excel>false</Excel>
    <XLSX>false</XLSX>
    <XLS>true</XLS>
    <Text>false</Text>
    <Delimiter xml:space="preserve">	</Delimiter>
    <Wrapper />
    <Extension>txt</Extension>
  </dtExportSettings>
</Settings>', 0, 1, CAST(N'2014-09-29T07:54:07.507' AS DateTime))
INSERT [dbo].[Reports] ([ReportID], [ReportName], [ReportType], [FileA], [FileAFileName], [FileB], [FileBFileName], [FileC], [FileCFileName], [FileD], [FileDFileName], [Rights], [Settings], [IsDefault], [Enable], [ModifiedDate]) VALUES (4, N'langDeviationReport_', 1, 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, N'DeviationReport.rdl', NULL, N'', NULL, N'', NULL, N'', N'', N'<Settings>
  <xs:schema id="Settings" xmlns="" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msdata="urn:schemas-microsoft-com:xml-msdata">
    <xs:element name="Settings" msdata:IsDataSet="true" msdata:UseCurrentLocale="true">
      <xs:complexType>
        <xs:choice minOccurs="0" maxOccurs="unbounded">
          <xs:element name="Parameters">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="ParamName" type="xs:string" minOccurs="0" />
                <xs:element name="ParamType" type="xs:string" minOccurs="0" />
                <xs:element name="DefaultValue" type="xs:string" minOccurs="0" />
                <xs:element name="Prompt" type="xs:string" minOccurs="0" />
                <xs:element name="SaveLastEnteredValue" type="xs:boolean" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
          <xs:element name="dtExportSettings">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="PDF" type="xs:boolean" minOccurs="0" />
                <xs:element name="TIF" type="xs:boolean" minOccurs="0" />
                <xs:element name="HTML" type="xs:boolean" minOccurs="0" />
                <xs:element name="Word" type="xs:boolean" minOccurs="0" />
                <xs:element name="RTF" type="xs:boolean" minOccurs="0" />
                <xs:element name="XML" type="xs:boolean" minOccurs="0" />
                <xs:element name="MHT" type="xs:boolean" minOccurs="0" />
                <xs:element name="Excel" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLSX" type="xs:boolean" minOccurs="0" />
                <xs:element name="XLS" type="xs:boolean" minOccurs="0" />
                <xs:element name="Text" type="xs:boolean" minOccurs="0" />
                <xs:element name="Delimiter" type="xs:string" minOccurs="0" />
                <xs:element name="Wrapper" type="xs:string" minOccurs="0" />
                <xs:element name="Extension" type="xs:string" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
        </xs:choice>
      </xs:complexType>
    </xs:element>
  </xs:schema>
  <Parameters>
    <ParamName>paramReconGroupID_</ParamName>
    <ParamType>Integer</ParamType>
    <DefaultValue>1</DefaultValue>
    <Prompt>ReconGroup</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <Parameters>
    <ParamName>paramDateTo_</ParamName>
    <ParamType>DateTime</ParamType>
    <Prompt>langPrintDate_</Prompt>
    <SaveLastEnteredValue>false</SaveLastEnteredValue>
  </Parameters>
  <dtExportSettings>
    <PDF>true</PDF>
    <TIF>true</TIF>
    <HTML>false</HTML>
    <Word>false</Word>
    <RTF>false</RTF>
    <XML>false</XML>
    <MHT>false</MHT>
    <Excel>false</Excel>
    <XLSX>false</XLSX>
    <XLS>true</XLS>
    <Text>false</Text>
    <Delimiter xml:space="preserve">	</Delimiter>
    <Wrapper />
    <Extension>txt</Extension>
  </dtExportSettings>
</Settings>', 0, 1, CAST(N'2014-09-29T07:54:40.663' AS DateTime))
SET IDENTITY_INSERT [dbo].[Reports] OFF
SET IDENTITY_INSERT [dbo].[UserProfiles] ON 

INSERT [dbo].[UserProfiles] ([UserProfileID], [UserProfileName], [EnableSysAdmin], [EnableEntityAdmin], [EnableUpdate], [EnableAutoRecon], [EnableArchive], [EnableReconRoules], [EnableRecon], [EnableReconDiff], [EnableManReg], [EnableReport], [EnableUndoUpdate]) VALUES (1, N'sysadmin', 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
INSERT [dbo].[UserProfiles] ([UserProfileID], [UserProfileName], [EnableSysAdmin], [EnableEntityAdmin], [EnableUpdate], [EnableAutoRecon], [EnableArchive], [EnableReconRoules], [EnableRecon], [EnableReconDiff], [EnableManReg], [EnableReport], [EnableUndoUpdate]) VALUES (2, N'admin', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
INSERT [dbo].[UserProfiles] ([UserProfileID], [UserProfileName], [EnableSysAdmin], [EnableEntityAdmin], [EnableUpdate], [EnableAutoRecon], [EnableArchive], [EnableReconRoules], [EnableRecon], [EnableReconDiff], [EnableManReg], [EnableReport], [EnableUndoUpdate]) VALUES (3, N'entityadmin', 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
INSERT [dbo].[UserProfiles] ([UserProfileID], [UserProfileName], [EnableSysAdmin], [EnableEntityAdmin], [EnableUpdate], [EnableAutoRecon], [EnableArchive], [EnableReconRoules], [EnableRecon], [EnableReconDiff], [EnableManReg], [EnableReport], [EnableUndoUpdate]) VALUES (4, N'user', 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
SET IDENTITY_INSERT [dbo].[UserProfiles] OFF
SET IDENTITY_INSERT [dbo].[Users] ON 

INSERT [dbo].[Users] ([UserID], [UserProfileID], [UserName], [Password], [Title], [FirstName], [MiddleName], [LastName], [Suffix], [EmailAdress], [Image], [ImageAdress], [Activated], [WinAut], [History], [Rights], [LastLogin], [IsLogged], [LanguageID]) VALUES (1, 1, N'sysadmin', N'edOf6mOlBpw+ctaphydAFQ==', N'', N'', NULL, N'', NULL, N'', NULL, NULL, 1, 0, N'<NewDataSet>
  <xs:schema id="NewDataSet" xmlns="" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msdata="urn:schemas-microsoft-com:xml-msdata">
    <xs:element name="NewDataSet" msdata:IsDataSet="true" msdata:UseCurrentLocale="true">
      <xs:complexType>
        <xs:choice minOccurs="0" maxOccurs="unbounded">
          <xs:element name="GeneralHistory">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="UBMultiImportEnable" type="xs:boolean" minOccurs="0" />
                <xs:element name="UBExcludeTransEnable" type="xs:boolean" minOccurs="0" />
                <xs:element name="UBUseDateFiltrationEnable" type="xs:boolean" minOccurs="0" />
                <xs:element name="AutoSizeRows" type="xs:boolean" minOccurs="0" />
                <xs:element name="ExportOpen" type="xs:boolean" minOccurs="0" />
                <xs:element name="FontSizeDataGridView" type="xs:int" minOccurs="0" />
                <xs:element name="ColorBank" type="xs:int" minOccurs="0" />
                <xs:element name="ColorNotBank" type="xs:int" minOccurs="0" />
                <xs:element name="ColorPositiveNumerics" type="xs:int" minOccurs="0" />
                <xs:element name="ColorNegativeNumerics" type="xs:int" minOccurs="0" />
                <xs:element name="ColorLink" type="xs:int" minOccurs="0" />
                <xs:element name="ColorDeviation" type="xs:int" minOccurs="0" />
                <xs:element name="ColorTemplateIndex" type="xs:int" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
          <xs:element name="ColumnHistory">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="ColummName" type="xs:string" minOccurs="0" />
                <xs:element name="Order" type="xs:int" minOccurs="0" />
                <xs:element name="Widht" type="xs:int" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
          <xs:element name="ColumnHistoryExtra">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="ColummName" type="xs:string" minOccurs="0" />
                <xs:element name="Order" type="xs:int" minOccurs="0" />
                <xs:element name="Widht" type="xs:int" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
          <xs:element name="TreeViewHistory">
            <xs:complexType>
              <xs:sequence>
                <xs:element name="ReconGroupID" type="xs:int" minOccurs="0" />
                <xs:element name="IsChecked" type="xs:boolean" minOccurs="0" />
                <xs:element name="IsSelected" type="xs:boolean" minOccurs="0" />
                <xs:element name="IsExpanded" type="xs:boolean" minOccurs="0" />
              </xs:sequence>
            </xs:complexType>
          </xs:element>
        </xs:choice>
      </xs:complexType>
    </xs:element>
  </xs:schema>
  <GeneralHistory>
    <UBMultiImportEnable>false</UBMultiImportEnable>
    <UBExcludeTransEnable>true</UBExcludeTransEnable>
    <UBUseDateFiltrationEnable>false</UBUseDateFiltrationEnable>
    <AutoSizeRows>false</AutoSizeRows>
    <ExportOpen>false</ExportOpen>
    <FontSizeDataGridView>9</FontSizeDataGridView>
    <ColorBank>-657931</ColorBank>
    <ColorNotBank>-1</ColorNotBank>
    <ColorPositiveNumerics>-16777216</ColorPositiveNumerics>
    <ColorNegativeNumerics>-2396013</ColorNegativeNumerics>
    <ColorLink>-16755726</ColorLink>
    <ColorDeviation>-16755726</ColorDeviation>
  </GeneralHistory>
</NewDataSet>', N'', CAST(N'2017-09-19T09:54:30.510' AS DateTime), 0, 1)
SET IDENTITY_INSERT [dbo].[Users] OFF
/****** Object:  Index [CurrencyID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [CurrencyID] ON [dbo].[Accounts]
(
	[CurrencyID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [ReconGroupID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [ReconGroupID] ON [dbo].[Accounts]
(
	[ReconGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [EntityID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [EntityID] ON [dbo].[ReconGroups]
(
	[EntityID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [ReconGroupID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [ReconGroupID] ON [dbo].[ReconRules]
(
	[ReconGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [SReconRuleID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [SReconRuleID] ON [dbo].[ReconRules]
(
	[SReconRuleID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [SReconRuleGroupID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [SReconRuleGroupID] ON [dbo].[ReconRulesStandard]
(
	[SReconRuleGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [AccountID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [AccountID] ON [dbo].[ReconTransHistory]
(
	[AccountID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [ReconHistoryID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [ReconHistoryID] ON [dbo].[ReconTransHistory]
(
	[ReconHistoryID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [ReconID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [ReconID] ON [dbo].[ReconTransHistory]
(
	[ReconID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [UpdateID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [UpdateID] ON [dbo].[ReconTransHistory]
(
	[UpdateID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [UserID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [UserID] ON [dbo].[ReconTransHistory]
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [ReconGroupID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [ReconGroupID] ON [dbo].[ReconTransHistoryOp]
(
	[ReconGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [UserID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [UserID] ON [dbo].[ReconTransHistoryOp]
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [AccountID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [AccountID] ON [dbo].[Transactions]
(
	[AccountID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [DevID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [DevID] ON [dbo].[Transactions]
(
	[DevID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [ReconID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [ReconID] ON [dbo].[Transactions]
(
	[ReconID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [UpdateID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [UpdateID] ON [dbo].[Transactions]
(
	[UpdateID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [UserID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [UserID] ON [dbo].[UpdateTrans]
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [LanguageID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [LanguageID] ON [dbo].[Users]
(
	[LanguageID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
/****** Object:  Index [UserProfileID]    Script Date: 2018-10-31 14:43:27 ******/
CREATE NONCLUSTERED INDEX [UserProfileID] ON [dbo].[Users]
(
	[UserProfileID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
ALTER TABLE [dbo].[Accounts] ADD  CONSTRAINT [DF_Accounts_Balance]  DEFAULT ((0)) FOR [Balance]
GO
ALTER TABLE [dbo].[DBLog] ADD  CONSTRAINT [DF_Table_1_Date]  DEFAULT (getdate()) FOR [LogDate]
GO
ALTER TABLE [dbo].[DBLog] ADD  DEFAULT ((0)) FOR [Status]
GO
ALTER TABLE [dbo].[DBLog] ADD  DEFAULT ((0)) FOR [TypeID]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  CONSTRAINT [DF_GeneralSettings_EnableMainImportsPath]  DEFAULT ((0)) FOR [EnableMainImportsPath]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  CONSTRAINT [DF_GeneralSettings_EnableAutoImportsPaths]  DEFAULT ((0)) FOR [EnableAutoImportsPaths]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  CONSTRAINT [DF_GeneralSettings_EnableMainArchivePaths]  DEFAULT ((0)) FOR [EnableMainArchivePaths]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ((0)) FOR [Reseller]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ('Pricka Konto') FOR [AppName]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ((0)) FOR [PBEnable]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ((0)) FOR [PBMailSendError]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ((0)) FOR [PBMailSendCompletedMessage]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ('') FOR [PBMailNotificationRecipient]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ((90)) FOR [DBLogDeleteDaysBackInTime]
GO
ALTER TABLE [dbo].[GeneralSettings] ADD  DEFAULT ((0)) FOR [GlobalLayoutAdminOnly]
GO
ALTER TABLE [dbo].[ImportInterfaces] ADD  CONSTRAINT [DF_ImportInterfaces_ModifiedDate]  DEFAULT (getdate()) FOR [ModifiedDate]
GO
ALTER TABLE [dbo].[ImportInterfaces] ADD  DEFAULT ((1)) FOR [ExcludeTransactions]
GO
ALTER TABLE [dbo].[Operation] ADD  CONSTRAINT [DF_Operation_Date]  DEFAULT (getdate()) FOR [Date]
GO
ALTER TABLE [dbo].[ReconGroups] ADD  DEFAULT ((0)) FOR [ReconcileInBackground]
GO
ALTER TABLE [dbo].[ReconRules] ADD  DEFAULT ((0)) FOR [Type]
GO
ALTER TABLE [dbo].[ReconRulesStandard] ADD  DEFAULT ((0)) FOR [Type]
GO
ALTER TABLE [dbo].[ReconTrans] ADD  CONSTRAINT [DF_ReconTrans_Date]  DEFAULT (getdate()) FOR [ReconDate]
GO
ALTER TABLE [dbo].[ReconTransHistory] ADD  DEFAULT ((0)) FOR [DeletedBundle]
GO
ALTER TABLE [dbo].[ReconTransHistoryDeleted] ADD  CONSTRAINT [DF_DateDeleted]  DEFAULT (getdate()) FOR [DateDeleted]
GO
ALTER TABLE [dbo].[ReconTransHistoryOp] ADD  CONSTRAINT [DF_Table_1_OpDate]  DEFAULT (getdate()) FOR [Date]
GO
ALTER TABLE [dbo].[Reports] ADD  CONSTRAINT [DF_Reports_ModifiedDate]  DEFAULT (getdate()) FOR [ModifiedDate]
GO
ALTER TABLE [dbo].[UpdateTrans] ADD  CONSTRAINT [DF_Table1_Date]  DEFAULT (getdate()) FOR [UpdateDate]
GO
ALTER TABLE [dbo].[Users] ADD  CONSTRAINT [DF_Users_Activated]  DEFAULT ((1)) FOR [Activated]
GO
ALTER TABLE [dbo].[Users] ADD  CONSTRAINT [DF_Users_WindAuthentication]  DEFAULT ((0)) FOR [WinAut]
GO
ALTER TABLE [dbo].[Accounts]  WITH CHECK ADD  CONSTRAINT [FK_Accounts_Currency] FOREIGN KEY([CurrencyID])
REFERENCES [dbo].[Currency] ([CurrencyID])
GO
ALTER TABLE [dbo].[Accounts] CHECK CONSTRAINT [FK_Accounts_Currency]
GO
ALTER TABLE [dbo].[Accounts]  WITH CHECK ADD  CONSTRAINT [FK_Accounts_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Accounts] CHECK CONSTRAINT [FK_Accounts_ReconGroups]
GO
ALTER TABLE [dbo].[Operation]  WITH CHECK ADD  CONSTRAINT [FK_Operation_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
GO
ALTER TABLE [dbo].[Operation] CHECK CONSTRAINT [FK_Operation_Users]
GO
ALTER TABLE [dbo].[ReconGroupGridLayout]  WITH CHECK ADD  CONSTRAINT [FK_ReconGroupGridLayout_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
GO
ALTER TABLE [dbo].[ReconGroupGridLayout] CHECK CONSTRAINT [FK_ReconGroupGridLayout_ReconGroups]
GO
ALTER TABLE [dbo].[ReconGroupGridLayout]  WITH CHECK ADD  CONSTRAINT [FK_ReconGroupGridLayout_TransactionGridLayouts] FOREIGN KEY([GridLayoutID])
REFERENCES [dbo].[TransactionGridLayouts] ([GridLayoutID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconGroupGridLayout] CHECK CONSTRAINT [FK_ReconGroupGridLayout_TransactionGridLayouts]
GO
ALTER TABLE [dbo].[ReconGroupGridLayout]  WITH CHECK ADD  CONSTRAINT [FK_ReconGroupGridLayout_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
GO
ALTER TABLE [dbo].[ReconGroupGridLayout] CHECK CONSTRAINT [FK_ReconGroupGridLayout_Users]
GO
ALTER TABLE [dbo].[ReconGroups]  WITH CHECK ADD  CONSTRAINT [FK_ReconGroups_Entities] FOREIGN KEY([EntityID])
REFERENCES [dbo].[Entities] ([EntityID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconGroups] CHECK CONSTRAINT [FK_ReconGroups_Entities]
GO
ALTER TABLE [dbo].[ReconRules]  WITH CHECK ADD  CONSTRAINT [FK_ReconRules_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconRules] CHECK CONSTRAINT [FK_ReconRules_ReconGroups]
GO
ALTER TABLE [dbo].[ReconRules]  WITH CHECK ADD  CONSTRAINT [FK_ReconRules_ReconRules] FOREIGN KEY([ReconRuleID])
REFERENCES [dbo].[ReconRules] ([ReconRuleID])
GO
ALTER TABLE [dbo].[ReconRules] CHECK CONSTRAINT [FK_ReconRules_ReconRules]
GO
ALTER TABLE [dbo].[ReconRules]  WITH CHECK ADD  CONSTRAINT [FK_ReconRules_ReconRulesStandard] FOREIGN KEY([SReconRuleID])
REFERENCES [dbo].[ReconRulesStandard] ([SReconRuleID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconRules] CHECK CONSTRAINT [FK_ReconRules_ReconRulesStandard]
GO
ALTER TABLE [dbo].[ReconRulesStandard]  WITH CHECK ADD  CONSTRAINT [FK_ReconRulesStandard_ReconRulesStandardGroups] FOREIGN KEY([SReconRuleGroupID])
REFERENCES [dbo].[ReconRulesStandardGroups] ([SReconRuleGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconRulesStandard] CHECK CONSTRAINT [FK_ReconRulesStandard_ReconRulesStandardGroups]
GO
ALTER TABLE [dbo].[ReconTransHistory]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistory_ReconTransHistoryOp] FOREIGN KEY([ReconHistoryID])
REFERENCES [dbo].[ReconTransHistoryOp] ([ReconHistoryID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconTransHistory] CHECK CONSTRAINT [FK_ReconTransHistory_ReconTransHistoryOp]
GO
ALTER TABLE [dbo].[ReconTransHistory]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistory_UpdateTrans] FOREIGN KEY([UpdateID])
REFERENCES [dbo].[UpdateTrans] ([UpdateID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconTransHistory] CHECK CONSTRAINT [FK_ReconTransHistory_UpdateTrans]
GO
ALTER TABLE [dbo].[ReconTransHistoryOp]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistoryOp_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[ReconTransHistoryOp] CHECK CONSTRAINT [FK_ReconTransHistoryOp_ReconGroups]
GO
ALTER TABLE [dbo].[ReconTransHistoryOp]  WITH CHECK ADD  CONSTRAINT [FK_ReconTransHistoryOp_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
GO
ALTER TABLE [dbo].[ReconTransHistoryOp] CHECK CONSTRAINT [FK_ReconTransHistoryOp_Users]
GO
ALTER TABLE [dbo].[TransactionGridLayouts]  WITH CHECK ADD  CONSTRAINT [FK_TransactionGridLayouts_ReconGroups] FOREIGN KEY([ReconGroupID])
REFERENCES [dbo].[ReconGroups] ([ReconGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[TransactionGridLayouts] CHECK CONSTRAINT [FK_TransactionGridLayouts_ReconGroups]
GO
ALTER TABLE [dbo].[TransactionGridLayouts]  WITH CHECK ADD  CONSTRAINT [FK_TransactionGridLayouts_TransactionGridLayoutsStandard] FOREIGN KEY([SGridLayoutID])
REFERENCES [dbo].[TransactionGridLayoutsStandard] ([SGridLayoutID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[TransactionGridLayouts] CHECK CONSTRAINT [FK_TransactionGridLayouts_TransactionGridLayoutsStandard]
GO
ALTER TABLE [dbo].[Transactions]  WITH CHECK ADD  CONSTRAINT [FK_Transactions_Accounts] FOREIGN KEY([AccountID])
REFERENCES [dbo].[Accounts] ([AccountID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Transactions] CHECK CONSTRAINT [FK_Transactions_Accounts]
GO
ALTER TABLE [dbo].[Transactions]  WITH CHECK ADD  CONSTRAINT [FK_Transactions_ReconTrans] FOREIGN KEY([ReconID])
REFERENCES [dbo].[ReconTrans] ([ReconID])
ON DELETE SET NULL
GO
ALTER TABLE [dbo].[Transactions] CHECK CONSTRAINT [FK_Transactions_ReconTrans]
GO
ALTER TABLE [dbo].[Transactions]  WITH CHECK ADD  CONSTRAINT [FK_Transactions_UpdateTrans] FOREIGN KEY([UpdateID])
REFERENCES [dbo].[UpdateTrans] ([UpdateID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Transactions] CHECK CONSTRAINT [FK_Transactions_UpdateTrans]
GO
ALTER TABLE [dbo].[UpdateTrans]  WITH CHECK ADD  CONSTRAINT [FK_UpdateTrans_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
GO
ALTER TABLE [dbo].[UpdateTrans] CHECK CONSTRAINT [FK_UpdateTrans_Users]
GO
ALTER TABLE [dbo].[UserLayout]  WITH CHECK ADD  CONSTRAINT [FK_UserLayout_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UserLayout] CHECK CONSTRAINT [FK_UserLayout_Users]
GO
ALTER TABLE [dbo].[Users]  WITH CHECK ADD  CONSTRAINT [FK_Users_Language] FOREIGN KEY([LanguageID])
REFERENCES [dbo].[Language] ([LanguageID])
GO
ALTER TABLE [dbo].[Users] CHECK CONSTRAINT [FK_Users_Language]
GO
ALTER TABLE [dbo].[Users]  WITH CHECK ADD  CONSTRAINT [FK_Users_UserProfiles] FOREIGN KEY([UserProfileID])
REFERENCES [dbo].[UserProfiles] ([UserProfileID])
GO
ALTER TABLE [dbo].[Users] CHECK CONSTRAINT [FK_Users_UserProfiles]
GO
USE [master]
GO
ALTER DATABASE [PrickaKonto] SET  READ_WRITE 
GO
USE [PrickaKonto]

GO
/************************************************* UPDATE DB 16 **************************************************/
PRINT 'Upgrading Database to version: 16';
GO
UPDATE [dbo].[GeneralSettings] SET DBVersion = 16 WHERE DBVersion = 15;
GO
CREATE TABLE [dbo].[AuditLog](
    [EventId] [int] IDENTITY(1,1) NOT NULL,
    [JsonData] [nvarchar](max) NULL,
    [TimeStamp] [datetime] NULL,
    [UserId] [int] NULL,
    [EntryType] [nvarchar](50) NULL,
 CONSTRAINT [PK_AuditLog] PRIMARY KEY CLUSTERED 
(
    [EventId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO
/****** Object:  Index [IX_AuditLog_EntryType]    Script Date: 2019-11-01 11:41:50 ******/
CREATE NONCLUSTERED INDEX [IX_AuditLog_EntryType] ON [dbo].[AuditLog]
(
    [EntryType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_AuditLog_TimeStamp]    Script Date: 2019-11-01 11:41:50 ******/
CREATE NONCLUSTERED INDEX [IX_AuditLog_TimeStamp] ON [dbo].[AuditLog]
(
    [TimeStamp] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/****** Object:  Index [IX_AuditLog_UserId]    Script Date: 2019-11-01 11:41:50 ******/
CREATE NONCLUSTERED INDEX [IX_AuditLog_UserId] ON [dbo].[AuditLog]
(
    [UserId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE [dbo].[UpdateTrans] ADD [ExcludeImported] [bit] NULL
GO
ALTER TABLE [dbo].[GeneralSettings] ADD [RemoveAuditLogsOlderThan] [int] NOT NULL DEFAULT 12
GO
/*************************************************END UPDATE DB 16 **************************************************/

/************************************************* UPDATE DB 17 **************************************************/
PRINT 'Upgrading Database to version: 17';
GO
UPDATE [dbo].[GeneralSettings] SET DBVersion = 17 WHERE DBVersion = 16;
GO
/****** Object:  Index [OpUserID]    Script Date: 2020-11-12 13:06:10 ******/
CREATE NONCLUSTERED INDEX [OpUserID] ON [dbo].[Transactions]
(
	[OpUserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Index [OpUserID]    Script Date: 2020-11-12 13:05:57 ******/
CREATE NONCLUSTERED INDEX [OpUserID] ON [dbo].[ReconTransHistory]
(
	[OpUserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Index [ColumnsSettingsID]    Script Date: 2020-11-12 13:38:04 ******/
CREATE NONCLUSTERED INDEX [ColumnsSettingsID] ON [dbo].[ColumnsSettings]
(
	[ColumnsSettingsID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Index [ColumnsSettingsID]    Script Date: 2020-11-12 13:39:03 ******/
CREATE NONCLUSTERED INDEX [ColumnsSettingsID] ON [dbo].[ReconGroups]
(
	[ColumnsSettingsID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/*************************************************END UPDATE DB 17 **************************************************/

/************************************************* UPDATE DB 18 **************************************************/
PRINT 'Upgrading Database to version: 18';
GO
UPDATE [dbo].[GeneralSettings] SET DBVersion = 18 WHERE DBVersion = 17;
GO
/****** Object:  Table [dbo].[GridLayouts]    Script Date: 2021-05-05 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[GridLayouts](
	[GridLayoutID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[GridType] [int] NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[XML] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_GridLayouts] PRIMARY KEY CLUSTERED 
(
	[GridLayoutID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

ALTER TABLE [dbo].[GridLayouts]  WITH CHECK ADD  CONSTRAINT [FK_GridLayouts_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[GridLayouts] CHECK CONSTRAINT [FK_GridLayouts_Users]
GO
ALTER TABLE [dbo].[UserProfiles] ADD [IsDefaultProfile] [bit] NOT NULL DEFAULT 1
GO
ALTER TABLE [dbo].[UserProfiles] ADD [UserProfilePermission] [nvarchar](max)
GO
/****** Object:  Table [dbo].[RightsGroups]    Script Date: 2021-05-21 09:16:56 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RightsGroups](
	[RightsGroupID] [int] IDENTITY(1,1) NOT NULL,
	[RightsGroupName] [nvarchar](50) NOT NULL,
	[RightsGroupConditions] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_RightsGroups] PRIMARY KEY CLUSTERED 
(
	[RightsGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[UsersRightsGroups]    Script Date: 2021-05-21 09:16:56 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UsersRightsGroups](
	[UserID] [int] NOT NULL,
	[RightsGroupID] [int] NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[UsersRightsGroups]  WITH CHECK ADD  CONSTRAINT [FK_UsersRightsGroups_RightsGroups] FOREIGN KEY([RightsGroupID])
REFERENCES [dbo].[RightsGroups] ([RightsGroupID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UsersRightsGroups] CHECK CONSTRAINT [FK_UsersRightsGroups_RightsGroups]
GO
ALTER TABLE [dbo].[UsersRightsGroups]  WITH CHECK ADD  CONSTRAINT [FK_UsersRightsGroups_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[Users] ([UserID])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[UsersRightsGroups] CHECK CONSTRAINT [FK_UsersRightsGroups_Users]
GO
/****** Object:  Index [UserID]    Script Date: 2021-05-21 09:23:23 ******/
CREATE CLUSTERED INDEX [UserID] ON [dbo].[UsersRightsGroups]
(
	[UserID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
/*************************************************END UPDATE DB 18 **************************************************/
/************************************************* UPDATE DB 25 **************************************************/
PRINT 'Upgrading Database to version: 25';
GO
UPDATE [dbo].[GeneralSettings] SET DBVersion = 25 WHERE DBVersion = 18;
GO

ALTER TABLE [dbo].[ReconRules] ADD [UpdatedByUserID] [int] NOT NULL DEFAULT 1
ALTER TABLE [dbo].[ReconRules]  WITH CHECK ADD CONSTRAINT [FK_ReconRules_Users] FOREIGN KEY([UpdatedByUserID])
REFERENCES [dbo].[Users] ([UserID])
ALTER TABLE [dbo].[ReconRules] ADD [UpdateDate] [datetime]
ALTER TABLE [dbo].[ReconRules] ALTER COLUMN ReconName NVARCHAR (100)

ALTER TABLE [dbo].[ReconRulesStandard] ADD [SUpdatedByUserID] [int] NOT NULL DEFAULT 1
ALTER TABLE [dbo].[ReconRulesStandard]  WITH CHECK ADD CONSTRAINT [FK_ReconRulesStandard_Users] FOREIGN KEY([SUpdatedByUserID])
REFERENCES [dbo].[Users] ([UserID])
ALTER TABLE [dbo].[ReconRulesStandard] ADD [SUpdateDate] [datetime] 
ALTER TABLE [dbo].[ReconRulesStandard] ALTER COLUMN SReconName NVARCHAR (100)
GO
/*************************************************END UPDATE DB 25 **************************************************/
/************************************************* UPDATE DB 26 **************************************************/
PRINT 'Upgrading Database to version: 26';
GO
UPDATE [dbo].[GeneralSettings] SET DBVersion = 26 WHERE DBVersion = 25;
GO
ALTER TABLE [dbo].[Transactions] WITH CHECK CHECK CONSTRAINT [FK_Transactions_Accounts]
ALTER TABLE [dbo].[Transactions] WITH CHECK CHECK CONSTRAINT [FK_Transactions_ReconTrans]
ALTER TABLE [dbo].[Transactions] WITH CHECK CHECK CONSTRAINT [FK_Transactions_UpdateTrans]
ALTER TABLE [dbo].[ReconTransHistory] WITH CHECK CHECK CONSTRAINT [FK_ReconTransHistory_ReconTransHistoryOp]
ALTER TABLE [dbo].[ReconTransHistory] WITH CHECK CHECK CONSTRAINT [FK_ReconTransHistory_UpdateTrans]
GO
/*************************************************END UPDATE DB 26 **************************************************/
/************************************************* UPDATE DB 27 **************************************************/
PRINT 'Upgrading Database to version: 27';
GO
UPDATE [dbo].[GeneralSettings] SET DBVersion = 27 WHERE DBVersion = 26;
GO
ALTER TABLE [dbo].[ImportInterfaces] ADD [AccessTokenURL] [nvarchar](max) NULL
ALTER TABLE [dbo].[ImportInterfaces] ADD [ClientID] [nvarchar](max) NULL
ALTER TABLE [dbo].[ImportInterfaces] ADD [ClientSecret] [nvarchar](max) NULL
GO
/*************************************************END UPDATE DB 27 **************************************************/